/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSavingsPlansPurchaseRecommendationGenerationRequest extends CostExplorerRequest
        implements
        ToCopyableBuilder<ListSavingsPlansPurchaseRecommendationGenerationRequest.Builder, ListSavingsPlansPurchaseRecommendationGenerationRequest> {
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationStatus")
            .getter(getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::generationStatusAsString))
            .setter(setter(Builder::generationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationStatus").build()).build();

    private static final SdkField<List<String>> RECOMMENDATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RecommendationIds")
            .getter(getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::recommendationIds))
            .setter(setter(Builder::recommendationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PageSize").getter(getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::pageSize))
            .setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(ListSavingsPlansPurchaseRecommendationGenerationRequest::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_STATUS_FIELD,
            RECOMMENDATION_IDS_FIELD, PAGE_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final String generationStatus;

    private final List<String> recommendationIds;

    private final Integer pageSize;

    private final String nextPageToken;

    private ListSavingsPlansPurchaseRecommendationGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.generationStatus = builder.generationStatus;
        this.recommendationIds = builder.recommendationIds;
        this.pageSize = builder.pageSize;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The status of the recommendation generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the recommendation generation.
     * @see GenerationStatus
     */
    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(generationStatus);
    }

    /**
     * <p>
     * The status of the recommendation generation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the recommendation generation.
     * @see GenerationStatus
     */
    public final String generationStatusAsString() {
        return generationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendationIds() {
        return recommendationIds != null && !(recommendationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs for each specific recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationIds} method.
     * </p>
     * 
     * @return The IDs for each specific recommendation.
     */
    public final List<String> recommendationIds() {
        return recommendationIds;
    }

    /**
     * <p>
     * The number of recommendations that you want returned in a single response object.
     * </p>
     * 
     * @return The number of recommendations that you want returned in a single response object.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendationIds() ? recommendationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSavingsPlansPurchaseRecommendationGenerationRequest)) {
            return false;
        }
        ListSavingsPlansPurchaseRecommendationGenerationRequest other = (ListSavingsPlansPurchaseRecommendationGenerationRequest) obj;
        return Objects.equals(generationStatusAsString(), other.generationStatusAsString())
                && hasRecommendationIds() == other.hasRecommendationIds()
                && Objects.equals(recommendationIds(), other.recommendationIds()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSavingsPlansPurchaseRecommendationGenerationRequest")
                .add("GenerationStatus", generationStatusAsString())
                .add("RecommendationIds", hasRecommendationIds() ? recommendationIds() : null).add("PageSize", pageSize())
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GenerationStatus":
            return Optional.ofNullable(clazz.cast(generationStatusAsString()));
        case "RecommendationIds":
            return Optional.ofNullable(clazz.cast(recommendationIds()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSavingsPlansPurchaseRecommendationGenerationRequest, T> g) {
        return obj -> g.apply((ListSavingsPlansPurchaseRecommendationGenerationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSavingsPlansPurchaseRecommendationGenerationRequest> {
        /**
         * <p>
         * The status of the recommendation generation.
         * </p>
         * 
         * @param generationStatus
         *        The status of the recommendation generation.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(String generationStatus);

        /**
         * <p>
         * The status of the recommendation generation.
         * </p>
         * 
         * @param generationStatus
         *        The status of the recommendation generation.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(GenerationStatus generationStatus);

        /**
         * <p>
         * The IDs for each specific recommendation.
         * </p>
         * 
         * @param recommendationIds
         *        The IDs for each specific recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(Collection<String> recommendationIds);

        /**
         * <p>
         * The IDs for each specific recommendation.
         * </p>
         * 
         * @param recommendationIds
         *        The IDs for each specific recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIds(String... recommendationIds);

        /**
         * <p>
         * The number of recommendations that you want returned in a single response object.
         * </p>
         * 
         * @param pageSize
         *        The number of recommendations that you want returned in a single response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String generationStatus;

        private List<String> recommendationIds = DefaultSdkAutoConstructList.getInstance();

        private Integer pageSize;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSavingsPlansPurchaseRecommendationGenerationRequest model) {
            super(model);
            generationStatus(model.generationStatus);
            recommendationIds(model.recommendationIds);
            pageSize(model.pageSize);
            nextPageToken(model.nextPageToken);
        }

        public final String getGenerationStatus() {
            return generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Collection<String> getRecommendationIds() {
            if (recommendationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return recommendationIds;
        }

        public final void setRecommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
        }

        @Override
        public final Builder recommendationIds(Collection<String> recommendationIds) {
            this.recommendationIds = RecommendationIdListCopier.copy(recommendationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationIds(String... recommendationIds) {
            recommendationIds(Arrays.asList(recommendationIds));
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSavingsPlansPurchaseRecommendationGenerationRequest build() {
            return new ListSavingsPlansPurchaseRecommendationGenerationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
