/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * You can use <code>RightsizingRecommendationConfiguration</code> to customize recommendations across two attributes.
 * You can choose to view recommendations for instances within the same instance families or across different instance
 * families. You can also choose to view your estimated savings that are associated with recommendations with
 * consideration of existing Savings Plans or Reserved Instance (RI) benefits, or neither.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RightsizingRecommendationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RightsizingRecommendationConfiguration.Builder, RightsizingRecommendationConfiguration> {
    private static final SdkField<String> RECOMMENDATION_TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationTarget")
            .getter(getter(RightsizingRecommendationConfiguration::recommendationTargetAsString))
            .setter(setter(Builder::recommendationTarget))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationTarget").build())
            .build();

    private static final SdkField<Boolean> BENEFITS_CONSIDERED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("BenefitsConsidered").getter(getter(RightsizingRecommendationConfiguration::benefitsConsidered))
            .setter(setter(Builder::benefitsConsidered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BenefitsConsidered").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_TARGET_FIELD,
            BENEFITS_CONSIDERED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationTarget;

    private final Boolean benefitsConsidered;

    private RightsizingRecommendationConfiguration(BuilderImpl builder) {
        this.recommendationTarget = builder.recommendationTarget;
        this.benefitsConsidered = builder.benefitsConsidered;
    }

    /**
     * <p>
     * The option to see recommendations within the same instance family or recommendations for instances across other
     * families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationTarget} will return {@link RecommendationTarget#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationTargetAsString}.
     * </p>
     * 
     * @return The option to see recommendations within the same instance family or recommendations for instances across
     *         other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
     * @see RecommendationTarget
     */
    public final RecommendationTarget recommendationTarget() {
        return RecommendationTarget.fromValue(recommendationTarget);
    }

    /**
     * <p>
     * The option to see recommendations within the same instance family or recommendations for instances across other
     * families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #recommendationTarget} will return {@link RecommendationTarget#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #recommendationTargetAsString}.
     * </p>
     * 
     * @return The option to see recommendations within the same instance family or recommendations for instances across
     *         other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
     * @see RecommendationTarget
     */
    public final String recommendationTargetAsString() {
        return recommendationTarget;
    }

    /**
     * <p>
     * The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value is
     * <code>TRUE</code>.
     * </p>
     * 
     * @return The option to consider RI or Savings Plans discount benefits in your savings calculation. The default
     *         value is <code>TRUE</code>.
     */
    public final Boolean benefitsConsidered() {
        return benefitsConsidered;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationTargetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(benefitsConsidered());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationConfiguration)) {
            return false;
        }
        RightsizingRecommendationConfiguration other = (RightsizingRecommendationConfiguration) obj;
        return Objects.equals(recommendationTargetAsString(), other.recommendationTargetAsString())
                && Objects.equals(benefitsConsidered(), other.benefitsConsidered());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RightsizingRecommendationConfiguration")
                .add("RecommendationTarget", recommendationTargetAsString()).add("BenefitsConsidered", benefitsConsidered())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationTarget":
            return Optional.ofNullable(clazz.cast(recommendationTargetAsString()));
        case "BenefitsConsidered":
            return Optional.ofNullable(clazz.cast(benefitsConsidered()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationConfiguration, T> g) {
        return obj -> g.apply((RightsizingRecommendationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RightsizingRecommendationConfiguration> {
        /**
         * <p>
         * The option to see recommendations within the same instance family or recommendations for instances across
         * other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
         * </p>
         * 
         * @param recommendationTarget
         *        The option to see recommendations within the same instance family or recommendations for instances
         *        across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
         * @see RecommendationTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationTarget
         */
        Builder recommendationTarget(String recommendationTarget);

        /**
         * <p>
         * The option to see recommendations within the same instance family or recommendations for instances across
         * other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
         * </p>
         * 
         * @param recommendationTarget
         *        The option to see recommendations within the same instance family or recommendations for instances
         *        across other families. The default value is <code>SAME_INSTANCE_FAMILY</code>.
         * @see RecommendationTarget
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationTarget
         */
        Builder recommendationTarget(RecommendationTarget recommendationTarget);

        /**
         * <p>
         * The option to consider RI or Savings Plans discount benefits in your savings calculation. The default value
         * is <code>TRUE</code>.
         * </p>
         * 
         * @param benefitsConsidered
         *        The option to consider RI or Savings Plans discount benefits in your savings calculation. The default
         *        value is <code>TRUE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder benefitsConsidered(Boolean benefitsConsidered);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationTarget;

        private Boolean benefitsConsidered;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationConfiguration model) {
            recommendationTarget(model.recommendationTarget);
            benefitsConsidered(model.benefitsConsidered);
        }

        public final String getRecommendationTarget() {
            return recommendationTarget;
        }

        public final void setRecommendationTarget(String recommendationTarget) {
            this.recommendationTarget = recommendationTarget;
        }

        @Override
        public final Builder recommendationTarget(String recommendationTarget) {
            this.recommendationTarget = recommendationTarget;
            return this;
        }

        @Override
        public final Builder recommendationTarget(RecommendationTarget recommendationTarget) {
            this.recommendationTarget(recommendationTarget == null ? null : recommendationTarget.toString());
            return this;
        }

        public final Boolean getBenefitsConsidered() {
            return benefitsConsidered;
        }

        public final void setBenefitsConsidered(Boolean benefitsConsidered) {
            this.benefitsConsidered = benefitsConsidered;
        }

        @Override
        public final Builder benefitsConsidered(Boolean benefitsConsidered) {
            this.benefitsConsidered = benefitsConsidered;
            return this;
        }

        @Override
        public RightsizingRecommendationConfiguration build() {
            return new RightsizingRecommendationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
