/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnalysisSummary;
import software.amazon.awssdk.services.costexplorer.model.AnalysisSummaryListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCommitmentPurchaseAnalysesResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ListCommitmentPurchaseAnalysesResponse> {
    private static final SdkField<List<AnalysisSummary>> ANALYSIS_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnalysisSummaryList").getter(ListCommitmentPurchaseAnalysesResponse.getter(ListCommitmentPurchaseAnalysesResponse::analysisSummaryList)).setter(ListCommitmentPurchaseAnalysesResponse.setter(Builder::analysisSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListCommitmentPurchaseAnalysesResponse.getter(ListCommitmentPurchaseAnalysesResponse::nextPageToken)).setter(ListCommitmentPurchaseAnalysesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SUMMARY_LIST_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCommitmentPurchaseAnalysesResponse.memberNameToFieldInitializer();
    private final List<AnalysisSummary> analysisSummaryList;
    private final String nextPageToken;

    private ListCommitmentPurchaseAnalysesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSummaryList = builder.analysisSummaryList;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasAnalysisSummaryList() {
        return this.analysisSummaryList != null && !(this.analysisSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AnalysisSummary> analysisSummaryList() {
        return this.analysisSummaryList;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisSummaryList() ? this.analysisSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCommitmentPurchaseAnalysesResponse)) {
            return false;
        }
        ListCommitmentPurchaseAnalysesResponse other = (ListCommitmentPurchaseAnalysesResponse)((Object)obj);
        return this.hasAnalysisSummaryList() == other.hasAnalysisSummaryList() && Objects.equals(this.analysisSummaryList(), other.analysisSummaryList()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCommitmentPurchaseAnalysesResponse").add("AnalysisSummaryList", this.hasAnalysisSummaryList() ? this.analysisSummaryList() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSummaryList": {
                return Optional.ofNullable(clazz.cast(this.analysisSummaryList()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AnalysisSummaryList", ANALYSIS_SUMMARY_LIST_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCommitmentPurchaseAnalysesResponse, T> g) {
        return obj -> g.apply((ListCommitmentPurchaseAnalysesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<AnalysisSummary> analysisSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCommitmentPurchaseAnalysesResponse model) {
            super(model);
            this.analysisSummaryList(model.analysisSummaryList);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<AnalysisSummary.Builder> getAnalysisSummaryList() {
            List<AnalysisSummary.Builder> result = AnalysisSummaryListCopier.copyToBuilder(this.analysisSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisSummaryList(Collection<AnalysisSummary.BuilderImpl> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copyFromBuilder(analysisSummaryList);
        }

        @Override
        public final Builder analysisSummaryList(Collection<AnalysisSummary> analysisSummaryList) {
            this.analysisSummaryList = AnalysisSummaryListCopier.copy(analysisSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(AnalysisSummary ... analysisSummaryList) {
            this.analysisSummaryList(Arrays.asList(analysisSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... analysisSummaryList) {
            this.analysisSummaryList(Stream.of(analysisSummaryList).map(c -> (AnalysisSummary)((AnalysisSummary.Builder)AnalysisSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListCommitmentPurchaseAnalysesResponse build() {
            return new ListCommitmentPurchaseAnalysesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCommitmentPurchaseAnalysesResponse> {
        public Builder analysisSummaryList(Collection<AnalysisSummary> var1);

        public Builder analysisSummaryList(AnalysisSummary ... var1);

        public Builder analysisSummaryList(Consumer<AnalysisSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

