/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.MetricsOverLookbackPeriodCopier;
import software.amazon.awssdk.services.costexplorer.model.RecommendationDetailHourlyMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansPurchaseAnalysisDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansPurchaseAnalysisDetails> {
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currencyCode)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookbackPeriodInHours").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::lookbackPeriodInHours)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::lookbackPeriodInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInHours").build()}).build();
    private static final SdkField<String> CURRENT_AVERAGE_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAverageCoverage").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currentAverageCoverage)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currentAverageCoverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageCoverage").build()}).build();
    private static final SdkField<String> CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentAverageHourlyOnDemandSpend").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currentAverageHourlyOnDemandSpend)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currentAverageHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentMaximumHourlyOnDemandSpend").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currentMaximumHourlyOnDemandSpend)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currentMaximumHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMaximumHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentMinimumHourlyOnDemandSpend").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currentMinimumHourlyOnDemandSpend)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currentMinimumHourlyOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMinimumHourlyOnDemandSpend").build()}).build();
    private static final SdkField<String> CURRENT_ON_DEMAND_SPEND_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentOnDemandSpend").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::currentOnDemandSpend)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::currentOnDemandSpend)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentOnDemandSpend").build()}).build();
    private static final SdkField<String> EXISTING_HOURLY_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExistingHourlyCommitment").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::existingHourlyCommitment)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::existingHourlyCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExistingHourlyCommitment").build()}).build();
    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HourlyCommitmentToPurchase").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::hourlyCommitmentToPurchase)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::hourlyCommitmentToPurchase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build()}).build();
    private static final SdkField<String> ESTIMATED_AVERAGE_COVERAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedAverageCoverage").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedAverageCoverage)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedAverageCoverage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageCoverage").build()}).build();
    private static final SdkField<String> ESTIMATED_AVERAGE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedAverageUtilization").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedAverageUtilization)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedAverageUtilization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageUtilization").build()}).build();
    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedMonthlySavingsAmount").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedMonthlySavingsAmount)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedMonthlySavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount").build()}).build();
    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedOnDemandCost").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedOnDemandCost)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedOnDemandCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build()}).build();
    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedOnDemandCostWithCurrentCommitment").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedOnDemandCostWithCurrentCommitment)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedOnDemandCostWithCurrentCommitment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCostWithCurrentCommitment").build()}).build();
    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedROI").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedROI)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedROI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()}).build();
    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedSavingsAmount").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedSavingsAmount)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedSavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build()}).build();
    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedSavingsPercentage").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedSavingsPercentage)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedSavingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build()}).build();
    private static final SdkField<String> ESTIMATED_COMMITMENT_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedCommitmentCost").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::estimatedCommitmentCost)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::estimatedCommitmentCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCommitmentCost").build()}).build();
    private static final SdkField<String> LATEST_USAGE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestUsageTimestamp").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::latestUsageTimestamp)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::latestUsageTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUsageTimestamp").build()}).build();
    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpfrontCost").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::upfrontCost)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::upfrontCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()}).build();
    private static final SdkField<String> ADDITIONAL_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalMetadata").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::additionalMetadata)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::additionalMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetadata").build()}).build();
    private static final SdkField<List<RecommendationDetailHourlyMetrics>> METRICS_OVER_LOOKBACK_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricsOverLookbackPeriod").getter(SavingsPlansPurchaseAnalysisDetails.getter(SavingsPlansPurchaseAnalysisDetails::metricsOverLookbackPeriod)).setter(SavingsPlansPurchaseAnalysisDetails.setter(Builder::metricsOverLookbackPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricsOverLookbackPeriod").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationDetailHourlyMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENCY_CODE_FIELD, LOOKBACK_PERIOD_IN_HOURS_FIELD, CURRENT_AVERAGE_COVERAGE_FIELD, CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_ON_DEMAND_SPEND_FIELD, EXISTING_HOURLY_COMMITMENT_FIELD, HOURLY_COMMITMENT_TO_PURCHASE_FIELD, ESTIMATED_AVERAGE_COVERAGE_FIELD, ESTIMATED_AVERAGE_UTILIZATION_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD, ESTIMATED_ON_DEMAND_COST_FIELD, ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD, ESTIMATED_ROI_FIELD, ESTIMATED_SAVINGS_AMOUNT_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, ESTIMATED_COMMITMENT_COST_FIELD, LATEST_USAGE_TIMESTAMP_FIELD, UPFRONT_COST_FIELD, ADDITIONAL_METADATA_FIELD, METRICS_OVER_LOOKBACK_PERIOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SavingsPlansPurchaseAnalysisDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String currencyCode;
    private final String lookbackPeriodInHours;
    private final String currentAverageCoverage;
    private final String currentAverageHourlyOnDemandSpend;
    private final String currentMaximumHourlyOnDemandSpend;
    private final String currentMinimumHourlyOnDemandSpend;
    private final String currentOnDemandSpend;
    private final String existingHourlyCommitment;
    private final String hourlyCommitmentToPurchase;
    private final String estimatedAverageCoverage;
    private final String estimatedAverageUtilization;
    private final String estimatedMonthlySavingsAmount;
    private final String estimatedOnDemandCost;
    private final String estimatedOnDemandCostWithCurrentCommitment;
    private final String estimatedROI;
    private final String estimatedSavingsAmount;
    private final String estimatedSavingsPercentage;
    private final String estimatedCommitmentCost;
    private final String latestUsageTimestamp;
    private final String upfrontCost;
    private final String additionalMetadata;
    private final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod;

    private SavingsPlansPurchaseAnalysisDetails(BuilderImpl builder) {
        this.currencyCode = builder.currencyCode;
        this.lookbackPeriodInHours = builder.lookbackPeriodInHours;
        this.currentAverageCoverage = builder.currentAverageCoverage;
        this.currentAverageHourlyOnDemandSpend = builder.currentAverageHourlyOnDemandSpend;
        this.currentMaximumHourlyOnDemandSpend = builder.currentMaximumHourlyOnDemandSpend;
        this.currentMinimumHourlyOnDemandSpend = builder.currentMinimumHourlyOnDemandSpend;
        this.currentOnDemandSpend = builder.currentOnDemandSpend;
        this.existingHourlyCommitment = builder.existingHourlyCommitment;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.estimatedAverageCoverage = builder.estimatedAverageCoverage;
        this.estimatedAverageUtilization = builder.estimatedAverageUtilization;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
        this.estimatedROI = builder.estimatedROI;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.estimatedCommitmentCost = builder.estimatedCommitmentCost;
        this.latestUsageTimestamp = builder.latestUsageTimestamp;
        this.upfrontCost = builder.upfrontCost;
        this.additionalMetadata = builder.additionalMetadata;
        this.metricsOverLookbackPeriod = builder.metricsOverLookbackPeriod;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final String lookbackPeriodInHours() {
        return this.lookbackPeriodInHours;
    }

    public final String currentAverageCoverage() {
        return this.currentAverageCoverage;
    }

    public final String currentAverageHourlyOnDemandSpend() {
        return this.currentAverageHourlyOnDemandSpend;
    }

    public final String currentMaximumHourlyOnDemandSpend() {
        return this.currentMaximumHourlyOnDemandSpend;
    }

    public final String currentMinimumHourlyOnDemandSpend() {
        return this.currentMinimumHourlyOnDemandSpend;
    }

    public final String currentOnDemandSpend() {
        return this.currentOnDemandSpend;
    }

    public final String existingHourlyCommitment() {
        return this.existingHourlyCommitment;
    }

    public final String hourlyCommitmentToPurchase() {
        return this.hourlyCommitmentToPurchase;
    }

    public final String estimatedAverageCoverage() {
        return this.estimatedAverageCoverage;
    }

    public final String estimatedAverageUtilization() {
        return this.estimatedAverageUtilization;
    }

    public final String estimatedMonthlySavingsAmount() {
        return this.estimatedMonthlySavingsAmount;
    }

    public final String estimatedOnDemandCost() {
        return this.estimatedOnDemandCost;
    }

    public final String estimatedOnDemandCostWithCurrentCommitment() {
        return this.estimatedOnDemandCostWithCurrentCommitment;
    }

    public final String estimatedROI() {
        return this.estimatedROI;
    }

    public final String estimatedSavingsAmount() {
        return this.estimatedSavingsAmount;
    }

    public final String estimatedSavingsPercentage() {
        return this.estimatedSavingsPercentage;
    }

    public final String estimatedCommitmentCost() {
        return this.estimatedCommitmentCost;
    }

    public final String latestUsageTimestamp() {
        return this.latestUsageTimestamp;
    }

    public final String upfrontCost() {
        return this.upfrontCost;
    }

    public final String additionalMetadata() {
        return this.additionalMetadata;
    }

    public final boolean hasMetricsOverLookbackPeriod() {
        return this.metricsOverLookbackPeriod != null && !(this.metricsOverLookbackPeriod instanceof SdkAutoConstructList);
    }

    public final List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod() {
        return this.metricsOverLookbackPeriod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInHours());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentAverageHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMaximumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentMinimumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingHourlyCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedAverageCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedAverageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedOnDemandCostWithCurrentCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCommitmentCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestUsageTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricsOverLookbackPeriod() ? this.metricsOverLookbackPeriod() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseAnalysisDetails)) {
            return false;
        }
        SavingsPlansPurchaseAnalysisDetails other = (SavingsPlansPurchaseAnalysisDetails)obj;
        return Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.lookbackPeriodInHours(), other.lookbackPeriodInHours()) && Objects.equals(this.currentAverageCoverage(), other.currentAverageCoverage()) && Objects.equals(this.currentAverageHourlyOnDemandSpend(), other.currentAverageHourlyOnDemandSpend()) && Objects.equals(this.currentMaximumHourlyOnDemandSpend(), other.currentMaximumHourlyOnDemandSpend()) && Objects.equals(this.currentMinimumHourlyOnDemandSpend(), other.currentMinimumHourlyOnDemandSpend()) && Objects.equals(this.currentOnDemandSpend(), other.currentOnDemandSpend()) && Objects.equals(this.existingHourlyCommitment(), other.existingHourlyCommitment()) && Objects.equals(this.hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase()) && Objects.equals(this.estimatedAverageCoverage(), other.estimatedAverageCoverage()) && Objects.equals(this.estimatedAverageUtilization(), other.estimatedAverageUtilization()) && Objects.equals(this.estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount()) && Objects.equals(this.estimatedOnDemandCost(), other.estimatedOnDemandCost()) && Objects.equals(this.estimatedOnDemandCostWithCurrentCommitment(), other.estimatedOnDemandCostWithCurrentCommitment()) && Objects.equals(this.estimatedROI(), other.estimatedROI()) && Objects.equals(this.estimatedSavingsAmount(), other.estimatedSavingsAmount()) && Objects.equals(this.estimatedSavingsPercentage(), other.estimatedSavingsPercentage()) && Objects.equals(this.estimatedCommitmentCost(), other.estimatedCommitmentCost()) && Objects.equals(this.latestUsageTimestamp(), other.latestUsageTimestamp()) && Objects.equals(this.upfrontCost(), other.upfrontCost()) && Objects.equals(this.additionalMetadata(), other.additionalMetadata()) && this.hasMetricsOverLookbackPeriod() == other.hasMetricsOverLookbackPeriod() && Objects.equals(this.metricsOverLookbackPeriod(), other.metricsOverLookbackPeriod());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansPurchaseAnalysisDetails").add("CurrencyCode", (Object)this.currencyCode()).add("LookbackPeriodInHours", (Object)this.lookbackPeriodInHours()).add("CurrentAverageCoverage", (Object)this.currentAverageCoverage()).add("CurrentAverageHourlyOnDemandSpend", (Object)this.currentAverageHourlyOnDemandSpend()).add("CurrentMaximumHourlyOnDemandSpend", (Object)this.currentMaximumHourlyOnDemandSpend()).add("CurrentMinimumHourlyOnDemandSpend", (Object)this.currentMinimumHourlyOnDemandSpend()).add("CurrentOnDemandSpend", (Object)this.currentOnDemandSpend()).add("ExistingHourlyCommitment", (Object)this.existingHourlyCommitment()).add("HourlyCommitmentToPurchase", (Object)this.hourlyCommitmentToPurchase()).add("EstimatedAverageCoverage", (Object)this.estimatedAverageCoverage()).add("EstimatedAverageUtilization", (Object)this.estimatedAverageUtilization()).add("EstimatedMonthlySavingsAmount", (Object)this.estimatedMonthlySavingsAmount()).add("EstimatedOnDemandCost", (Object)this.estimatedOnDemandCost()).add("EstimatedOnDemandCostWithCurrentCommitment", (Object)this.estimatedOnDemandCostWithCurrentCommitment()).add("EstimatedROI", (Object)this.estimatedROI()).add("EstimatedSavingsAmount", (Object)this.estimatedSavingsAmount()).add("EstimatedSavingsPercentage", (Object)this.estimatedSavingsPercentage()).add("EstimatedCommitmentCost", (Object)this.estimatedCommitmentCost()).add("LatestUsageTimestamp", (Object)this.latestUsageTimestamp()).add("UpfrontCost", (Object)this.upfrontCost()).add("AdditionalMetadata", (Object)this.additionalMetadata()).add("MetricsOverLookbackPeriod", this.hasMetricsOverLookbackPeriod() ? this.metricsOverLookbackPeriod() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "LookbackPeriodInHours": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInHours()));
            }
            case "CurrentAverageCoverage": {
                return Optional.ofNullable(clazz.cast(this.currentAverageCoverage()));
            }
            case "CurrentAverageHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentAverageHourlyOnDemandSpend()));
            }
            case "CurrentMaximumHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentMaximumHourlyOnDemandSpend()));
            }
            case "CurrentMinimumHourlyOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentMinimumHourlyOnDemandSpend()));
            }
            case "CurrentOnDemandSpend": {
                return Optional.ofNullable(clazz.cast(this.currentOnDemandSpend()));
            }
            case "ExistingHourlyCommitment": {
                return Optional.ofNullable(clazz.cast(this.existingHourlyCommitment()));
            }
            case "HourlyCommitmentToPurchase": {
                return Optional.ofNullable(clazz.cast(this.hourlyCommitmentToPurchase()));
            }
            case "EstimatedAverageCoverage": {
                return Optional.ofNullable(clazz.cast(this.estimatedAverageCoverage()));
            }
            case "EstimatedAverageUtilization": {
                return Optional.ofNullable(clazz.cast(this.estimatedAverageUtilization()));
            }
            case "EstimatedMonthlySavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavingsAmount()));
            }
            case "EstimatedOnDemandCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCost()));
            }
            case "EstimatedOnDemandCostWithCurrentCommitment": {
                return Optional.ofNullable(clazz.cast(this.estimatedOnDemandCostWithCurrentCommitment()));
            }
            case "EstimatedROI": {
                return Optional.ofNullable(clazz.cast(this.estimatedROI()));
            }
            case "EstimatedSavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedSavingsAmount()));
            }
            case "EstimatedSavingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.estimatedSavingsPercentage()));
            }
            case "EstimatedCommitmentCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedCommitmentCost()));
            }
            case "LatestUsageTimestamp": {
                return Optional.ofNullable(clazz.cast(this.latestUsageTimestamp()));
            }
            case "UpfrontCost": {
                return Optional.ofNullable(clazz.cast(this.upfrontCost()));
            }
            case "AdditionalMetadata": {
                return Optional.ofNullable(clazz.cast(this.additionalMetadata()));
            }
            case "MetricsOverLookbackPeriod": {
                return Optional.ofNullable(clazz.cast(this.metricsOverLookbackPeriod()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("LookbackPeriodInHours", LOOKBACK_PERIOD_IN_HOURS_FIELD);
        map.put("CurrentAverageCoverage", CURRENT_AVERAGE_COVERAGE_FIELD);
        map.put("CurrentAverageHourlyOnDemandSpend", CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMaximumHourlyOnDemandSpend", CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentMinimumHourlyOnDemandSpend", CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD);
        map.put("CurrentOnDemandSpend", CURRENT_ON_DEMAND_SPEND_FIELD);
        map.put("ExistingHourlyCommitment", EXISTING_HOURLY_COMMITMENT_FIELD);
        map.put("HourlyCommitmentToPurchase", HOURLY_COMMITMENT_TO_PURCHASE_FIELD);
        map.put("EstimatedAverageCoverage", ESTIMATED_AVERAGE_COVERAGE_FIELD);
        map.put("EstimatedAverageUtilization", ESTIMATED_AVERAGE_UTILIZATION_FIELD);
        map.put("EstimatedMonthlySavingsAmount", ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedOnDemandCost", ESTIMATED_ON_DEMAND_COST_FIELD);
        map.put("EstimatedOnDemandCostWithCurrentCommitment", ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD);
        map.put("EstimatedROI", ESTIMATED_ROI_FIELD);
        map.put("EstimatedSavingsAmount", ESTIMATED_SAVINGS_AMOUNT_FIELD);
        map.put("EstimatedSavingsPercentage", ESTIMATED_SAVINGS_PERCENTAGE_FIELD);
        map.put("EstimatedCommitmentCost", ESTIMATED_COMMITMENT_COST_FIELD);
        map.put("LatestUsageTimestamp", LATEST_USAGE_TIMESTAMP_FIELD);
        map.put("UpfrontCost", UPFRONT_COST_FIELD);
        map.put("AdditionalMetadata", ADDITIONAL_METADATA_FIELD);
        map.put("MetricsOverLookbackPeriod", METRICS_OVER_LOOKBACK_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseAnalysisDetails, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseAnalysisDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String currencyCode;
        private String lookbackPeriodInHours;
        private String currentAverageCoverage;
        private String currentAverageHourlyOnDemandSpend;
        private String currentMaximumHourlyOnDemandSpend;
        private String currentMinimumHourlyOnDemandSpend;
        private String currentOnDemandSpend;
        private String existingHourlyCommitment;
        private String hourlyCommitmentToPurchase;
        private String estimatedAverageCoverage;
        private String estimatedAverageUtilization;
        private String estimatedMonthlySavingsAmount;
        private String estimatedOnDemandCost;
        private String estimatedOnDemandCostWithCurrentCommitment;
        private String estimatedROI;
        private String estimatedSavingsAmount;
        private String estimatedSavingsPercentage;
        private String estimatedCommitmentCost;
        private String latestUsageTimestamp;
        private String upfrontCost;
        private String additionalMetadata;
        private List<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseAnalysisDetails model) {
            this.currencyCode(model.currencyCode);
            this.lookbackPeriodInHours(model.lookbackPeriodInHours);
            this.currentAverageCoverage(model.currentAverageCoverage);
            this.currentAverageHourlyOnDemandSpend(model.currentAverageHourlyOnDemandSpend);
            this.currentMaximumHourlyOnDemandSpend(model.currentMaximumHourlyOnDemandSpend);
            this.currentMinimumHourlyOnDemandSpend(model.currentMinimumHourlyOnDemandSpend);
            this.currentOnDemandSpend(model.currentOnDemandSpend);
            this.existingHourlyCommitment(model.existingHourlyCommitment);
            this.hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            this.estimatedAverageCoverage(model.estimatedAverageCoverage);
            this.estimatedAverageUtilization(model.estimatedAverageUtilization);
            this.estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            this.estimatedOnDemandCost(model.estimatedOnDemandCost);
            this.estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
            this.estimatedROI(model.estimatedROI);
            this.estimatedSavingsAmount(model.estimatedSavingsAmount);
            this.estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            this.estimatedCommitmentCost(model.estimatedCommitmentCost);
            this.latestUsageTimestamp(model.latestUsageTimestamp);
            this.upfrontCost(model.upfrontCost);
            this.additionalMetadata(model.additionalMetadata);
            this.metricsOverLookbackPeriod(model.metricsOverLookbackPeriod);
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getLookbackPeriodInHours() {
            return this.lookbackPeriodInHours;
        }

        public final void setLookbackPeriodInHours(String lookbackPeriodInHours) {
            this.lookbackPeriodInHours = lookbackPeriodInHours;
        }

        @Override
        public final Builder lookbackPeriodInHours(String lookbackPeriodInHours) {
            this.lookbackPeriodInHours = lookbackPeriodInHours;
            return this;
        }

        public final String getCurrentAverageCoverage() {
            return this.currentAverageCoverage;
        }

        public final void setCurrentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
        }

        @Override
        public final Builder currentAverageCoverage(String currentAverageCoverage) {
            this.currentAverageCoverage = currentAverageCoverage;
            return this;
        }

        public final String getCurrentAverageHourlyOnDemandSpend() {
            return this.currentAverageHourlyOnDemandSpend;
        }

        public final void setCurrentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMaximumHourlyOnDemandSpend() {
            return this.currentMaximumHourlyOnDemandSpend;
        }

        public final void setCurrentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentMinimumHourlyOnDemandSpend() {
            return this.currentMinimumHourlyOnDemandSpend;
        }

        public final void setCurrentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
            return this;
        }

        public final String getCurrentOnDemandSpend() {
            return this.currentOnDemandSpend;
        }

        public final void setCurrentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
        }

        @Override
        public final Builder currentOnDemandSpend(String currentOnDemandSpend) {
            this.currentOnDemandSpend = currentOnDemandSpend;
            return this;
        }

        public final String getExistingHourlyCommitment() {
            return this.existingHourlyCommitment;
        }

        public final void setExistingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
        }

        @Override
        public final Builder existingHourlyCommitment(String existingHourlyCommitment) {
            this.existingHourlyCommitment = existingHourlyCommitment;
            return this;
        }

        public final String getHourlyCommitmentToPurchase() {
            return this.hourlyCommitmentToPurchase;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final String getEstimatedAverageCoverage() {
            return this.estimatedAverageCoverage;
        }

        public final void setEstimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
        }

        @Override
        public final Builder estimatedAverageCoverage(String estimatedAverageCoverage) {
            this.estimatedAverageCoverage = estimatedAverageCoverage;
            return this;
        }

        public final String getEstimatedAverageUtilization() {
            return this.estimatedAverageUtilization;
        }

        public final void setEstimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
        }

        @Override
        public final Builder estimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
            return this;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return this.estimatedMonthlySavingsAmount;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final String getEstimatedOnDemandCost() {
            return this.estimatedOnDemandCost;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return this.estimatedOnDemandCostWithCurrentCommitment;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        public final String getEstimatedROI() {
            return this.estimatedROI;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final String getEstimatedSavingsAmount() {
            return this.estimatedSavingsAmount;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final String getEstimatedSavingsPercentage() {
            return this.estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getEstimatedCommitmentCost() {
            return this.estimatedCommitmentCost;
        }

        public final void setEstimatedCommitmentCost(String estimatedCommitmentCost) {
            this.estimatedCommitmentCost = estimatedCommitmentCost;
        }

        @Override
        public final Builder estimatedCommitmentCost(String estimatedCommitmentCost) {
            this.estimatedCommitmentCost = estimatedCommitmentCost;
            return this;
        }

        public final String getLatestUsageTimestamp() {
            return this.latestUsageTimestamp;
        }

        public final void setLatestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
        }

        @Override
        public final Builder latestUsageTimestamp(String latestUsageTimestamp) {
            this.latestUsageTimestamp = latestUsageTimestamp;
            return this;
        }

        public final String getUpfrontCost() {
            return this.upfrontCost;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final String getAdditionalMetadata() {
            return this.additionalMetadata;
        }

        public final void setAdditionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
        }

        @Override
        public final Builder additionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        public final List<RecommendationDetailHourlyMetrics.Builder> getMetricsOverLookbackPeriod() {
            List<RecommendationDetailHourlyMetrics.Builder> result = MetricsOverLookbackPeriodCopier.copyToBuilder(this.metricsOverLookbackPeriod);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics.BuilderImpl> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copyFromBuilder(metricsOverLookbackPeriod);
        }

        @Override
        public final Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod = MetricsOverLookbackPeriodCopier.copy(metricsOverLookbackPeriod);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics ... metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod(Arrays.asList(metricsOverLookbackPeriod));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder> ... metricsOverLookbackPeriod) {
            this.metricsOverLookbackPeriod(Stream.of(metricsOverLookbackPeriod).map(c -> (RecommendationDetailHourlyMetrics)((RecommendationDetailHourlyMetrics.Builder)RecommendationDetailHourlyMetrics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SavingsPlansPurchaseAnalysisDetails build() {
            return new SavingsPlansPurchaseAnalysisDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansPurchaseAnalysisDetails> {
        public Builder currencyCode(String var1);

        public Builder lookbackPeriodInHours(String var1);

        public Builder currentAverageCoverage(String var1);

        public Builder currentAverageHourlyOnDemandSpend(String var1);

        public Builder currentMaximumHourlyOnDemandSpend(String var1);

        public Builder currentMinimumHourlyOnDemandSpend(String var1);

        public Builder currentOnDemandSpend(String var1);

        public Builder existingHourlyCommitment(String var1);

        public Builder hourlyCommitmentToPurchase(String var1);

        public Builder estimatedAverageCoverage(String var1);

        public Builder estimatedAverageUtilization(String var1);

        public Builder estimatedMonthlySavingsAmount(String var1);

        public Builder estimatedOnDemandCost(String var1);

        public Builder estimatedOnDemandCostWithCurrentCommitment(String var1);

        public Builder estimatedROI(String var1);

        public Builder estimatedSavingsAmount(String var1);

        public Builder estimatedSavingsPercentage(String var1);

        public Builder estimatedCommitmentCost(String var1);

        public Builder latestUsageTimestamp(String var1);

        public Builder upfrontCost(String var1);

        public Builder additionalMetadata(String var1);

        public Builder metricsOverLookbackPeriod(Collection<RecommendationDetailHourlyMetrics> var1);

        public Builder metricsOverLookbackPeriod(RecommendationDetailHourlyMetrics ... var1);

        public Builder metricsOverLookbackPeriod(Consumer<RecommendationDetailHourlyMetrics.Builder> ... var1);
    }
}

