/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansAmortizedCommitment;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansSavings;
import software.amazon.awssdk.services.costexplorer.model.SavingsPlansUtilization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SavingsPlansUtilizationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SavingsPlansUtilizationDetail> {
    private static final SdkField<String> SAVINGS_PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPlanArn").getter(SavingsPlansUtilizationDetail.getter(SavingsPlansUtilizationDetail::savingsPlanArn)).setter(SavingsPlansUtilizationDetail.setter(Builder::savingsPlanArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlanArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(SavingsPlansUtilizationDetail.getter(SavingsPlansUtilizationDetail::attributes)).setter(SavingsPlansUtilizationDetail.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<SavingsPlansUtilization> UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Utilization").getter(SavingsPlansUtilizationDetail.getter(SavingsPlansUtilizationDetail::utilization)).setter(SavingsPlansUtilizationDetail.setter(Builder::utilization)).constructor(SavingsPlansUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()}).build();
    private static final SdkField<SavingsPlansSavings> SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Savings").getter(SavingsPlansUtilizationDetail.getter(SavingsPlansUtilizationDetail::savings)).setter(SavingsPlansUtilizationDetail.setter(Builder::savings)).constructor(SavingsPlansSavings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Savings").build()}).build();
    private static final SdkField<SavingsPlansAmortizedCommitment> AMORTIZED_COMMITMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AmortizedCommitment").getter(SavingsPlansUtilizationDetail.getter(SavingsPlansUtilizationDetail::amortizedCommitment)).setter(SavingsPlansUtilizationDetail.setter(Builder::amortizedCommitment)).constructor(SavingsPlansAmortizedCommitment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmortizedCommitment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLAN_ARN_FIELD, ATTRIBUTES_FIELD, UTILIZATION_FIELD, SAVINGS_FIELD, AMORTIZED_COMMITMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SavingsPlansUtilizationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String savingsPlanArn;
    private final Map<String, String> attributes;
    private final SavingsPlansUtilization utilization;
    private final SavingsPlansSavings savings;
    private final SavingsPlansAmortizedCommitment amortizedCommitment;

    private SavingsPlansUtilizationDetail(BuilderImpl builder) {
        this.savingsPlanArn = builder.savingsPlanArn;
        this.attributes = builder.attributes;
        this.utilization = builder.utilization;
        this.savings = builder.savings;
        this.amortizedCommitment = builder.amortizedCommitment;
    }

    public final String savingsPlanArn() {
        return this.savingsPlanArn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final SavingsPlansUtilization utilization() {
        return this.utilization;
    }

    public final SavingsPlansSavings savings() {
        return this.savings;
    }

    public final SavingsPlansAmortizedCommitment amortizedCommitment() {
        return this.amortizedCommitment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.utilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.savings());
        hashCode = 31 * hashCode + Objects.hashCode(this.amortizedCommitment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansUtilizationDetail)) {
            return false;
        }
        SavingsPlansUtilizationDetail other = (SavingsPlansUtilizationDetail)obj;
        return Objects.equals(this.savingsPlanArn(), other.savingsPlanArn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.utilization(), other.utilization()) && Objects.equals(this.savings(), other.savings()) && Objects.equals(this.amortizedCommitment(), other.amortizedCommitment());
    }

    public final String toString() {
        return ToString.builder((String)"SavingsPlansUtilizationDetail").add("SavingsPlanArn", (Object)this.savingsPlanArn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Utilization", (Object)this.utilization()).add("Savings", (Object)this.savings()).add("AmortizedCommitment", (Object)this.amortizedCommitment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SavingsPlanArn": {
                return Optional.ofNullable(clazz.cast(this.savingsPlanArn()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "Utilization": {
                return Optional.ofNullable(clazz.cast(this.utilization()));
            }
            case "Savings": {
                return Optional.ofNullable(clazz.cast(this.savings()));
            }
            case "AmortizedCommitment": {
                return Optional.ofNullable(clazz.cast(this.amortizedCommitment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SavingsPlanArn", SAVINGS_PLAN_ARN_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("Utilization", UTILIZATION_FIELD);
        map.put("Savings", SAVINGS_FIELD);
        map.put("AmortizedCommitment", AMORTIZED_COMMITMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansUtilizationDetail, T> g) {
        return obj -> g.apply((SavingsPlansUtilizationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String savingsPlanArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private SavingsPlansUtilization utilization;
        private SavingsPlansSavings savings;
        private SavingsPlansAmortizedCommitment amortizedCommitment;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansUtilizationDetail model) {
            this.savingsPlanArn(model.savingsPlanArn);
            this.attributes(model.attributes);
            this.utilization(model.utilization);
            this.savings(model.savings);
            this.amortizedCommitment(model.amortizedCommitment);
        }

        public final String getSavingsPlanArn() {
            return this.savingsPlanArn;
        }

        public final void setSavingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
        }

        @Override
        public final Builder savingsPlanArn(String savingsPlanArn) {
            this.savingsPlanArn = savingsPlanArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final SavingsPlansUtilization.Builder getUtilization() {
            return this.utilization != null ? this.utilization.toBuilder() : null;
        }

        public final void setUtilization(SavingsPlansUtilization.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        @Override
        public final Builder utilization(SavingsPlansUtilization utilization) {
            this.utilization = utilization;
            return this;
        }

        public final SavingsPlansSavings.Builder getSavings() {
            return this.savings != null ? this.savings.toBuilder() : null;
        }

        public final void setSavings(SavingsPlansSavings.BuilderImpl savings) {
            this.savings = savings != null ? savings.build() : null;
        }

        @Override
        public final Builder savings(SavingsPlansSavings savings) {
            this.savings = savings;
            return this;
        }

        public final SavingsPlansAmortizedCommitment.Builder getAmortizedCommitment() {
            return this.amortizedCommitment != null ? this.amortizedCommitment.toBuilder() : null;
        }

        public final void setAmortizedCommitment(SavingsPlansAmortizedCommitment.BuilderImpl amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment != null ? amortizedCommitment.build() : null;
        }

        @Override
        public final Builder amortizedCommitment(SavingsPlansAmortizedCommitment amortizedCommitment) {
            this.amortizedCommitment = amortizedCommitment;
            return this;
        }

        public SavingsPlansUtilizationDetail build() {
            return new SavingsPlansUtilizationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SavingsPlansUtilizationDetail> {
        public Builder savingsPlanArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder utilization(SavingsPlansUtilization var1);

        default public Builder utilization(Consumer<SavingsPlansUtilization.Builder> utilization) {
            return this.utilization((SavingsPlansUtilization)((SavingsPlansUtilization.Builder)SavingsPlansUtilization.builder().applyMutation(utilization)).build());
        }

        public Builder savings(SavingsPlansSavings var1);

        default public Builder savings(Consumer<SavingsPlansSavings.Builder> savings) {
            return this.savings((SavingsPlansSavings)((SavingsPlansSavings.Builder)SavingsPlansSavings.builder().applyMutation(savings)).build());
        }

        public Builder amortizedCommitment(SavingsPlansAmortizedCommitment var1);

        default public Builder amortizedCommitment(Consumer<SavingsPlansAmortizedCommitment.Builder> amortizedCommitment) {
            return this.amortizedCommitment((SavingsPlansAmortizedCommitment)((SavingsPlansAmortizedCommitment.Builder)SavingsPlansAmortizedCommitment.builder().applyMutation(amortizedCommitment)).build());
        }
    }
}

