/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageComparisonsResponse;

public class GetCostAndUsageComparisonsIterable
implements SdkIterable<GetCostAndUsageComparisonsResponse> {
    private final CostExplorerClient client;
    private final GetCostAndUsageComparisonsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCostAndUsageComparisonsIterable(CostExplorerClient client, GetCostAndUsageComparisonsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetCostAndUsageComparisonsResponseFetcher();
    }

    public Iterator<GetCostAndUsageComparisonsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CostAndUsageComparison> costAndUsageComparisons() {
        Function<GetCostAndUsageComparisonsResponse, Iterator> getIterator = response -> {
            if (response != null && response.costAndUsageComparisons() != null) {
                return response.costAndUsageComparisons().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetCostAndUsageComparisonsResponseFetcher
    implements SyncPageFetcher<GetCostAndUsageComparisonsResponse> {
        private GetCostAndUsageComparisonsResponseFetcher() {
        }

        public boolean hasNextPage(GetCostAndUsageComparisonsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public GetCostAndUsageComparisonsResponse nextPage(GetCostAndUsageComparisonsResponse previousPage) {
            if (previousPage == null) {
                return GetCostAndUsageComparisonsIterable.this.client.getCostAndUsageComparisons(GetCostAndUsageComparisonsIterable.this.firstRequest);
            }
            return GetCostAndUsageComparisonsIterable.this.client.getCostAndUsageComparisons((GetCostAndUsageComparisonsRequest)((Object)GetCostAndUsageComparisonsIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

