/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.CostComparisonDriver;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostComparisonDriversResponse;

public class GetCostComparisonDriversPublisher
implements SdkPublisher<GetCostComparisonDriversResponse> {
    private final CostExplorerAsyncClient client;
    private final GetCostComparisonDriversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCostComparisonDriversPublisher(CostExplorerAsyncClient client, GetCostComparisonDriversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCostComparisonDriversPublisher(CostExplorerAsyncClient client, GetCostComparisonDriversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCostComparisonDriversResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCostComparisonDriversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CostComparisonDriver> costComparisonDrivers() {
        Function<GetCostComparisonDriversResponse, Iterator> getIterator = response -> {
            if (response != null && response.costComparisonDrivers() != null) {
                return response.costComparisonDrivers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCostComparisonDriversResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCostComparisonDriversResponseFetcher
    implements AsyncPageFetcher<GetCostComparisonDriversResponse> {
        private GetCostComparisonDriversResponseFetcher() {
        }

        public boolean hasNextPage(GetCostComparisonDriversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetCostComparisonDriversResponse> nextPage(GetCostComparisonDriversResponse previousPage) {
            if (previousPage == null) {
                return GetCostComparisonDriversPublisher.this.client.getCostComparisonDrivers(GetCostComparisonDriversPublisher.this.firstRequest);
            }
            return GetCostComparisonDriversPublisher.this.client.getCostComparisonDrivers((GetCostComparisonDriversRequest)((Object)GetCostComparisonDriversPublisher.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

