/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about the <code>AttributeTypesSelector </code>where the rule-based identity resolution uses
 * to match profiles. You can choose how profiles are compared across attribute types and which attribute to use for
 * matching from each type. There are three attribute types you can configure:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Email type
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can choose from <code>Email</code>, <code>BusinessEmail</code>, and <code>PersonalEmail</code>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Phone number type
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can choose from <code>Phone</code>, <code>HomePhone</code>, and <code>MobilePhone</code>
 * </p>
 * </li>
 * </ul>
 * </li>
 * <li>
 * <p>
 * Address type
 * </p>
 * <ul>
 * <li>
 * <p>
 * You can choose from <code>Address</code>, <code>BusinessAddress</code>, <code>MaillingAddress</code>, and
 * <code>ShippingAddress</code>
 * </p>
 * </li>
 * </ul>
 * </li>
 * </ul>
 * <p>
 * You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>AttributeMatchingModel</code>
 * . When choosing <code>MANY_TO_MANY</code>, the system can match attribute across the sub-types of an attribute type.
 * For example, if the value of the <code>Email</code> field of Profile A and the value of <code>BusinessEmail</code>
 * field of Profile B matches, the two profiles are matched on the Email type. When choosing <code>ONE_TO_ONE</code> the
 * system can only match if the sub-types are exact matches. For example, only when the value of the <code>Email</code>
 * field of Profile A and the value of the <code>Email</code> field of Profile B matches, the two profiles are matched
 * on the Email type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttributeTypesSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<AttributeTypesSelector.Builder, AttributeTypesSelector> {
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeMatchingModel").getter(getter(AttributeTypesSelector::attributeMatchingModelAsString))
            .setter(setter(Builder::attributeMatchingModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeMatchingModel").build())
            .build();

    private static final SdkField<List<String>> ADDRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Address")
            .getter(getter(AttributeTypesSelector::address))
            .setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PHONE_NUMBER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PhoneNumber")
            .getter(getter(AttributeTypesSelector::phoneNumber))
            .setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EMAIL_ADDRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EmailAddress")
            .getter(getter(AttributeTypesSelector::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ATTRIBUTE_MATCHING_MODEL_FIELD, ADDRESS_FIELD, PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeMatchingModel;

    private final List<String> address;

    private final List<String> phoneNumber;

    private final List<String> emailAddress;

    private AttributeTypesSelector(BuilderImpl builder) {
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.address = builder.address;
        this.phoneNumber = builder.phoneNumber;
        this.emailAddress = builder.emailAddress;
    }

    /**
     * <p>
     * Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
     * <code>MANY_TO_MANY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
     *         <code>MANY_TO_MANY</code>.
     * @see AttributeMatchingModel
     */
    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(attributeMatchingModel);
    }

    /**
     * <p>
     * Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
     * <code>MANY_TO_MANY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #attributeMatchingModel} will return {@link AttributeMatchingModel#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #attributeMatchingModelAsString}.
     * </p>
     * 
     * @return Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
     *         <code>MANY_TO_MANY</code>.
     * @see AttributeMatchingModel
     */
    public final String attributeMatchingModelAsString() {
        return attributeMatchingModel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Address property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAddress() {
        return address != null && !(address instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
     * <code>MaillingAddress</code>, and <code>ShippingAddress</code>.
     * </p>
     * <p>
     * You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match profile
     * based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to choose the
     * <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address type and specify the
     * <code>Address.City</code> on the matching rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddress} method.
     * </p>
     * 
     * @return The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
     *         <code>MaillingAddress</code>, and <code>ShippingAddress</code>.</p>
     *         <p>
     *         You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match
     *         profile based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to
     *         choose the <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address
     *         type and specify the <code>Address.City</code> on the matching rule.
     */
    public final List<String> address() {
        return address;
    }

    /**
     * For responses, this returns true if the service returned a value for the PhoneNumber property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPhoneNumber() {
        return phoneNumber != null && !(phoneNumber instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>, <code>HomePhoneNumber</code>,
     * and <code>MobilePhoneNumber</code>.
     * </p>
     * <p>
     * You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if you want to
     * match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose the <code>Phone</code>
     * and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only specify the
     * <code>PhoneNumber</code> on the matching rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPhoneNumber} method.
     * </p>
     * 
     * @return The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>,
     *         <code>HomePhoneNumber</code>, and <code>MobilePhoneNumber</code>.</p>
     *         <p>
     *         You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if you
     *         want to match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose the
     *         <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only
     *         specify the <code>PhoneNumber</code> on the matching rule.
     */
    public final List<String> phoneNumber() {
        return phoneNumber;
    }

    /**
     * For responses, this returns true if the service returned a value for the EmailAddress property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEmailAddress() {
        return emailAddress != null && !(emailAddress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Email</code> type. You can choose from <code>EmailAddress</code>, <code>BusinessEmailAddress</code> and
     * <code>PersonalEmailAddress</code>.
     * </p>
     * <p>
     * You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if you want to
     * match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code>, you need to choose
     * the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to represent the
     * <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the matching rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEmailAddress} method.
     * </p>
     * 
     * @return The <code>Email</code> type. You can choose from <code>EmailAddress</code>,
     *         <code>BusinessEmailAddress</code> and <code>PersonalEmailAddress</code>.</p>
     *         <p>
     *         You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if you
     *         want to match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code>,
     *         you need to choose the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to
     *         represent the <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the
     *         matching rule.
     */
    public final List<String> emailAddress() {
        return emailAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddress() ? address() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPhoneNumber() ? phoneNumber() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEmailAddress() ? emailAddress() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributeTypesSelector)) {
            return false;
        }
        AttributeTypesSelector other = (AttributeTypesSelector) obj;
        return Objects.equals(attributeMatchingModelAsString(), other.attributeMatchingModelAsString())
                && hasAddress() == other.hasAddress() && Objects.equals(address(), other.address())
                && hasPhoneNumber() == other.hasPhoneNumber() && Objects.equals(phoneNumber(), other.phoneNumber())
                && hasEmailAddress() == other.hasEmailAddress() && Objects.equals(emailAddress(), other.emailAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AttributeTypesSelector").add("AttributeMatchingModel", attributeMatchingModelAsString())
                .add("Address", hasAddress() ? address() : null).add("PhoneNumber", hasPhoneNumber() ? phoneNumber() : null)
                .add("EmailAddress", hasEmailAddress() ? emailAddress() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeMatchingModel":
            return Optional.ofNullable(clazz.cast(attributeMatchingModelAsString()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttributeTypesSelector, T> g) {
        return obj -> g.apply((AttributeTypesSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AttributeTypesSelector> {
        /**
         * <p>
         * Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
         * <code>MANY_TO_MANY</code>.
         * </p>
         * 
         * @param attributeMatchingModel
         *        Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
         *        <code>MANY_TO_MANY</code>.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(String attributeMatchingModel);

        /**
         * <p>
         * Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
         * <code>MANY_TO_MANY</code>.
         * </p>
         * 
         * @param attributeMatchingModel
         *        Configures the <code>AttributeMatchingModel</code>, you can either choose <code>ONE_TO_ONE</code> or
         *        <code>MANY_TO_MANY</code>.
         * @see AttributeMatchingModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AttributeMatchingModel
         */
        Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel);

        /**
         * <p>
         * The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
         * <code>MaillingAddress</code>, and <code>ShippingAddress</code>.
         * </p>
         * <p>
         * You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match profile
         * based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to choose the
         * <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address type and specify
         * the <code>Address.City</code> on the matching rule.
         * </p>
         * 
         * @param address
         *        The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
         *        <code>MaillingAddress</code>, and <code>ShippingAddress</code>.</p>
         *        <p>
         *        You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match
         *        profile based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to
         *        choose the <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address
         *        type and specify the <code>Address.City</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(Collection<String> address);

        /**
         * <p>
         * The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
         * <code>MaillingAddress</code>, and <code>ShippingAddress</code>.
         * </p>
         * <p>
         * You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match profile
         * based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to choose the
         * <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address type and specify
         * the <code>Address.City</code> on the matching rule.
         * </p>
         * 
         * @param address
         *        The <code>Address</code> type. You can choose from <code>Address</code>, <code>BusinessAddress</code>,
         *        <code>MaillingAddress</code>, and <code>ShippingAddress</code>.</p>
         *        <p>
         *        You only can use the Address type in the <code>MatchingRule</code>. For example, if you want to match
         *        profile based on <code>BusinessAddress.City</code> or <code>MaillingAddress.City</code>, you need to
         *        choose the <code>BusinessAddress</code> and the <code>MaillingAddress</code> to represent the Address
         *        type and specify the <code>Address.City</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String... address);

        /**
         * <p>
         * The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>, <code>HomePhoneNumber</code>
         * , and <code>MobilePhoneNumber</code>.
         * </p>
         * <p>
         * You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if you want
         * to match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose the
         * <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only
         * specify the <code>PhoneNumber</code> on the matching rule.
         * </p>
         * 
         * @param phoneNumber
         *        The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>,
         *        <code>HomePhoneNumber</code>, and <code>MobilePhoneNumber</code>.</p>
         *        <p>
         *        You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if
         *        you want to match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose
         *        the <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type
         *        and only specify the <code>PhoneNumber</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(Collection<String> phoneNumber);

        /**
         * <p>
         * The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>, <code>HomePhoneNumber</code>
         * , and <code>MobilePhoneNumber</code>.
         * </p>
         * <p>
         * You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if you want
         * to match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose the
         * <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type and only
         * specify the <code>PhoneNumber</code> on the matching rule.
         * </p>
         * 
         * @param phoneNumber
         *        The <code>PhoneNumber</code> type. You can choose from <code>PhoneNumber</code>,
         *        <code>HomePhoneNumber</code>, and <code>MobilePhoneNumber</code>.</p>
         *        <p>
         *        You only can use the <code>PhoneNumber</code> type in the <code>MatchingRule</code>. For example, if
         *        you want to match a profile based on <code>Phone</code> or <code>HomePhone</code>, you need to choose
         *        the <code>Phone</code> and the <code>HomePhone</code> to represent the <code>PhoneNumber</code> type
         *        and only specify the <code>PhoneNumber</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String... phoneNumber);

        /**
         * <p>
         * The <code>Email</code> type. You can choose from <code>EmailAddress</code>, <code>BusinessEmailAddress</code>
         * and <code>PersonalEmailAddress</code>.
         * </p>
         * <p>
         * You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if you
         * want to match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code>, you
         * need to choose the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to represent
         * the <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the matching rule.
         * </p>
         * 
         * @param emailAddress
         *        The <code>Email</code> type. You can choose from <code>EmailAddress</code>,
         *        <code>BusinessEmailAddress</code> and <code>PersonalEmailAddress</code>.</p>
         *        <p>
         *        You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if
         *        you want to match profile based on <code>PersonalEmailAddress</code> or
         *        <code>BusinessEmailAddress</code>, you need to choose the <code>PersonalEmailAddress</code> and the
         *        <code>BusinessEmailAddress</code> to represent the <code>EmailAddress</code> type and only specify the
         *        <code>EmailAddress</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(Collection<String> emailAddress);

        /**
         * <p>
         * The <code>Email</code> type. You can choose from <code>EmailAddress</code>, <code>BusinessEmailAddress</code>
         * and <code>PersonalEmailAddress</code>.
         * </p>
         * <p>
         * You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if you
         * want to match profile based on <code>PersonalEmailAddress</code> or <code>BusinessEmailAddress</code>, you
         * need to choose the <code>PersonalEmailAddress</code> and the <code>BusinessEmailAddress</code> to represent
         * the <code>EmailAddress</code> type and only specify the <code>EmailAddress</code> on the matching rule.
         * </p>
         * 
         * @param emailAddress
         *        The <code>Email</code> type. You can choose from <code>EmailAddress</code>,
         *        <code>BusinessEmailAddress</code> and <code>PersonalEmailAddress</code>.</p>
         *        <p>
         *        You only can use the <code>EmailAddress</code> type in the <code>MatchingRule</code>. For example, if
         *        you want to match profile based on <code>PersonalEmailAddress</code> or
         *        <code>BusinessEmailAddress</code>, you need to choose the <code>PersonalEmailAddress</code> and the
         *        <code>BusinessEmailAddress</code> to represent the <code>EmailAddress</code> type and only specify the
         *        <code>EmailAddress</code> on the matching rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String... emailAddress);
    }

    static final class BuilderImpl implements Builder {
        private String attributeMatchingModel;

        private List<String> address = DefaultSdkAutoConstructList.getInstance();

        private List<String> phoneNumber = DefaultSdkAutoConstructList.getInstance();

        private List<String> emailAddress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AttributeTypesSelector model) {
            attributeMatchingModel(model.attributeMatchingModel);
            address(model.address);
            phoneNumber(model.phoneNumber);
            emailAddress(model.emailAddress);
        }

        public final String getAttributeMatchingModel() {
            return attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final Collection<String> getAddress() {
            if (address instanceof SdkAutoConstructList) {
                return null;
            }
            return address;
        }

        public final void setAddress(Collection<String> address) {
            this.address = AddressListCopier.copy(address);
        }

        @Override
        public final Builder address(Collection<String> address) {
            this.address = AddressListCopier.copy(address);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder address(String... address) {
            address(Arrays.asList(address));
            return this;
        }

        public final Collection<String> getPhoneNumber() {
            if (phoneNumber instanceof SdkAutoConstructList) {
                return null;
            }
            return phoneNumber;
        }

        public final void setPhoneNumber(Collection<String> phoneNumber) {
            this.phoneNumber = PhoneNumberListCopier.copy(phoneNumber);
        }

        @Override
        public final Builder phoneNumber(Collection<String> phoneNumber) {
            this.phoneNumber = PhoneNumberListCopier.copy(phoneNumber);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder phoneNumber(String... phoneNumber) {
            phoneNumber(Arrays.asList(phoneNumber));
            return this;
        }

        public final Collection<String> getEmailAddress() {
            if (emailAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return emailAddress;
        }

        public final void setEmailAddress(Collection<String> emailAddress) {
            this.emailAddress = EmailListCopier.copy(emailAddress);
        }

        @Override
        public final Builder emailAddress(Collection<String> emailAddress) {
            this.emailAddress = EmailListCopier.copy(emailAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder emailAddress(String... emailAddress) {
            emailAddress(Arrays.asList(emailAddress));
            return this;
        }

        @Override
        public AttributeTypesSelector build() {
            return new AttributeTypesSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
