/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileObjectTypeTemplateRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<GetProfileObjectTypeTemplateRequest.Builder, GetProfileObjectTypeTemplateRequest> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(GetProfileObjectTypeTemplateRequest::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("TemplateId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD));

    private final String templateId;

    private GetProfileObjectTypeTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
    }

    /**
     * <p>
     * A unique identifier for the object template.
     * </p>
     * 
     * @return A unique identifier for the object template.
     */
    public final String templateId() {
        return templateId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileObjectTypeTemplateRequest)) {
            return false;
        }
        GetProfileObjectTypeTemplateRequest other = (GetProfileObjectTypeTemplateRequest) obj;
        return Objects.equals(templateId(), other.templateId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileObjectTypeTemplateRequest").add("TemplateId", templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileObjectTypeTemplateRequest, T> g) {
        return obj -> g.apply((GetProfileObjectTypeTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileObjectTypeTemplateRequest> {
        /**
         * <p>
         * A unique identifier for the object template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileObjectTypeTemplateRequest model) {
            super(model);
            templateId(model.templateId);
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetProfileObjectTypeTemplateRequest build() {
            return new GetProfileObjectTypeTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
