/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response of the Rule-based matching request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleBasedMatchingResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleBasedMatchingResponse.Builder, RuleBasedMatchingResponse> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(RuleBasedMatchingResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<MatchingRule>> MATCHING_RULES_FIELD = SdkField
            .<List<MatchingRule>> builder(MarshallingType.LIST)
            .memberName("MatchingRules")
            .getter(getter(RuleBasedMatchingResponse::matchingRules))
            .setter(setter(Builder::matchingRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchingRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchingRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchingRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RuleBasedMatchingResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> MAX_ALLOWED_RULE_LEVEL_FOR_MERGING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllowedRuleLevelForMerging")
            .getter(getter(RuleBasedMatchingResponse::maxAllowedRuleLevelForMerging))
            .setter(setter(Builder::maxAllowedRuleLevelForMerging))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedRuleLevelForMerging")
                    .build()).build();

    private static final SdkField<Integer> MAX_ALLOWED_RULE_LEVEL_FOR_MATCHING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllowedRuleLevelForMatching")
            .getter(getter(RuleBasedMatchingResponse::maxAllowedRuleLevelForMatching))
            .setter(setter(Builder::maxAllowedRuleLevelForMatching))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllowedRuleLevelForMatching")
                    .build()).build();

    private static final SdkField<AttributeTypesSelector> ATTRIBUTE_TYPES_SELECTOR_FIELD = SdkField
            .<AttributeTypesSelector> builder(MarshallingType.SDK_POJO).memberName("AttributeTypesSelector")
            .getter(getter(RuleBasedMatchingResponse::attributeTypesSelector)).setter(setter(Builder::attributeTypesSelector))
            .constructor(AttributeTypesSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeTypesSelector").build())
            .build();

    private static final SdkField<ConflictResolution> CONFLICT_RESOLUTION_FIELD = SdkField
            .<ConflictResolution> builder(MarshallingType.SDK_POJO).memberName("ConflictResolution")
            .getter(getter(RuleBasedMatchingResponse::conflictResolution)).setter(setter(Builder::conflictResolution))
            .constructor(ConflictResolution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConflictResolution").build())
            .build();

    private static final SdkField<ExportingConfig> EXPORTING_CONFIG_FIELD = SdkField
            .<ExportingConfig> builder(MarshallingType.SDK_POJO).memberName("ExportingConfig")
            .getter(getter(RuleBasedMatchingResponse::exportingConfig)).setter(setter(Builder::exportingConfig))
            .constructor(ExportingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            MATCHING_RULES_FIELD, STATUS_FIELD, MAX_ALLOWED_RULE_LEVEL_FOR_MERGING_FIELD,
            MAX_ALLOWED_RULE_LEVEL_FOR_MATCHING_FIELD, ATTRIBUTE_TYPES_SELECTOR_FIELD, CONFLICT_RESOLUTION_FIELD,
            EXPORTING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final List<MatchingRule> matchingRules;

    private final String status;

    private final Integer maxAllowedRuleLevelForMerging;

    private final Integer maxAllowedRuleLevelForMatching;

    private final AttributeTypesSelector attributeTypesSelector;

    private final ConflictResolution conflictResolution;

    private final ExportingConfig exportingConfig;

    private RuleBasedMatchingResponse(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.matchingRules = builder.matchingRules;
        this.status = builder.status;
        this.maxAllowedRuleLevelForMerging = builder.maxAllowedRuleLevelForMerging;
        this.maxAllowedRuleLevelForMatching = builder.maxAllowedRuleLevelForMatching;
        this.attributeTypesSelector = builder.attributeTypesSelector;
        this.conflictResolution = builder.conflictResolution;
        this.exportingConfig = builder.exportingConfig;
    }

    /**
     * <p>
     * The flag that enables the rule-based matching process of duplicate profiles.
     * </p>
     * 
     * @return The flag that enables the rule-based matching process of duplicate profiles.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the MatchingRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMatchingRules() {
        return matchingRules != null && !(matchingRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configures how the rule-based matching process should match profiles. You can have up to 15
     * <code>MatchingRule</code> in the <code>MatchingRules</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatchingRules} method.
     * </p>
     * 
     * @return Configures how the rule-based matching process should match profiles. You can have up to 15
     *         <code>MatchingRule</code> in the <code>MatchingRules</code>.
     */
    public final List<MatchingRule> matchingRules() {
        return matchingRules;
    }

    /**
     * <p>
     * PENDING
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first status after configuration a rule-based matching rule. If it is an existing domain, the rule-based
     * Identity Resolution waits one hour before creating the matching rule. If it is a new domain, the system will skip
     * the <code>PENDING</code> stage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * IN_PROGRESS
     * </p>
     * <ul>
     * <li>
     * <p>
     * The system is creating the rule-based matching rule. Under this status, the system is evaluating the existing
     * data and you can no longer change the Rule-based matching configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * ACTIVE
     * </p>
     * <ul>
     * <li>
     * <p>
     * The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleBasedMatchingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return PENDING</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first status after configuration a rule-based matching rule. If it is an existing domain, the
     *         rule-based Identity Resolution waits one hour before creating the matching rule. If it is a new domain,
     *         the system will skip the <code>PENDING</code> stage.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         IN_PROGRESS
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The system is creating the rule-based matching rule. Under this status, the system is evaluating the
     *         existing data and you can no longer change the Rule-based matching configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         ACTIVE
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
     *         </p>
     *         </li>
     * @see RuleBasedMatchingStatus
     */
    public final RuleBasedMatchingStatus status() {
        return RuleBasedMatchingStatus.fromValue(status);
    }

    /**
     * <p>
     * PENDING
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first status after configuration a rule-based matching rule. If it is an existing domain, the rule-based
     * Identity Resolution waits one hour before creating the matching rule. If it is a new domain, the system will skip
     * the <code>PENDING</code> stage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * IN_PROGRESS
     * </p>
     * <ul>
     * <li>
     * <p>
     * The system is creating the rule-based matching rule. Under this status, the system is evaluating the existing
     * data and you can no longer change the Rule-based matching configuration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * ACTIVE
     * </p>
     * <ul>
     * <li>
     * <p>
     * The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RuleBasedMatchingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return PENDING</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first status after configuration a rule-based matching rule. If it is an existing domain, the
     *         rule-based Identity Resolution waits one hour before creating the matching rule. If it is a new domain,
     *         the system will skip the <code>PENDING</code> stage.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         IN_PROGRESS
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The system is creating the rule-based matching rule. Under this status, the system is evaluating the
     *         existing data and you can no longer change the Rule-based matching configuration.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         ACTIVE
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
     *         </p>
     *         </li>
     * @see RuleBasedMatchingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html">MatchingRule</a>
     * </p>
     * 
     * @return <a
     *         href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html">MatchingRule
     *         </a>
     */
    public final Integer maxAllowedRuleLevelForMerging() {
        return maxAllowedRuleLevelForMerging;
    }

    /**
     * <p>
     * Indicates the maximum allowed rule level.
     * </p>
     * 
     * @return Indicates the maximum allowed rule level.
     */
    public final Integer maxAllowedRuleLevelForMatching() {
        return maxAllowedRuleLevelForMatching;
    }

    /**
     * <p>
     * Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution
     * uses to match profiles.
     * </p>
     * 
     * @return Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity
     *         resolution uses to match profiles.
     */
    public final AttributeTypesSelector attributeTypesSelector() {
        return attributeTypesSelector;
    }

    /**
     * Returns the value of the ConflictResolution property for this object.
     * 
     * @return The value of the ConflictResolution property for this object.
     */
    public final ConflictResolution conflictResolution() {
        return conflictResolution;
    }

    /**
     * Returns the value of the ExportingConfig property for this object.
     * 
     * @return The value of the ExportingConfig property for this object.
     */
    public final ExportingConfig exportingConfig() {
        return exportingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchingRules() ? matchingRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllowedRuleLevelForMerging());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllowedRuleLevelForMatching());
        hashCode = 31 * hashCode + Objects.hashCode(attributeTypesSelector());
        hashCode = 31 * hashCode + Objects.hashCode(conflictResolution());
        hashCode = 31 * hashCode + Objects.hashCode(exportingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBasedMatchingResponse)) {
            return false;
        }
        RuleBasedMatchingResponse other = (RuleBasedMatchingResponse) obj;
        return Objects.equals(enabled(), other.enabled()) && hasMatchingRules() == other.hasMatchingRules()
                && Objects.equals(matchingRules(), other.matchingRules())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(maxAllowedRuleLevelForMerging(), other.maxAllowedRuleLevelForMerging())
                && Objects.equals(maxAllowedRuleLevelForMatching(), other.maxAllowedRuleLevelForMatching())
                && Objects.equals(attributeTypesSelector(), other.attributeTypesSelector())
                && Objects.equals(conflictResolution(), other.conflictResolution())
                && Objects.equals(exportingConfig(), other.exportingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleBasedMatchingResponse").add("Enabled", enabled())
                .add("MatchingRules", hasMatchingRules() ? matchingRules() : null).add("Status", statusAsString())
                .add("MaxAllowedRuleLevelForMerging", maxAllowedRuleLevelForMerging())
                .add("MaxAllowedRuleLevelForMatching", maxAllowedRuleLevelForMatching())
                .add("AttributeTypesSelector", attributeTypesSelector()).add("ConflictResolution", conflictResolution())
                .add("ExportingConfig", exportingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "MatchingRules":
            return Optional.ofNullable(clazz.cast(matchingRules()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MaxAllowedRuleLevelForMerging":
            return Optional.ofNullable(clazz.cast(maxAllowedRuleLevelForMerging()));
        case "MaxAllowedRuleLevelForMatching":
            return Optional.ofNullable(clazz.cast(maxAllowedRuleLevelForMatching()));
        case "AttributeTypesSelector":
            return Optional.ofNullable(clazz.cast(attributeTypesSelector()));
        case "ConflictResolution":
            return Optional.ofNullable(clazz.cast(conflictResolution()));
        case "ExportingConfig":
            return Optional.ofNullable(clazz.cast(exportingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RuleBasedMatchingResponse, T> g) {
        return obj -> g.apply((RuleBasedMatchingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleBasedMatchingResponse> {
        /**
         * <p>
         * The flag that enables the rule-based matching process of duplicate profiles.
         * </p>
         * 
         * @param enabled
         *        The flag that enables the rule-based matching process of duplicate profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Configures how the rule-based matching process should match profiles. You can have up to 15
         * <code>MatchingRule</code> in the <code>MatchingRules</code>.
         * </p>
         * 
         * @param matchingRules
         *        Configures how the rule-based matching process should match profiles. You can have up to 15
         *        <code>MatchingRule</code> in the <code>MatchingRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingRules(Collection<MatchingRule> matchingRules);

        /**
         * <p>
         * Configures how the rule-based matching process should match profiles. You can have up to 15
         * <code>MatchingRule</code> in the <code>MatchingRules</code>.
         * </p>
         * 
         * @param matchingRules
         *        Configures how the rule-based matching process should match profiles. You can have up to 15
         *        <code>MatchingRule</code> in the <code>MatchingRules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchingRules(MatchingRule... matchingRules);

        /**
         * <p>
         * Configures how the rule-based matching process should match profiles. You can have up to 15
         * <code>MatchingRule</code> in the <code>MatchingRules</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.customerprofiles.model.MatchingRule.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.customerprofiles.model.MatchingRule#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.customerprofiles.model.MatchingRule.Builder#build()} is called
         * immediately and its result is passed to {@link #matchingRules(List<MatchingRule>)}.
         * 
         * @param matchingRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.customerprofiles.model.MatchingRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matchingRules(java.util.Collection<MatchingRule>)
         */
        Builder matchingRules(Consumer<MatchingRule.Builder>... matchingRules);

        /**
         * <p>
         * PENDING
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first status after configuration a rule-based matching rule. If it is an existing domain, the rule-based
         * Identity Resolution waits one hour before creating the matching rule. If it is a new domain, the system will
         * skip the <code>PENDING</code> stage.
         * </p>
         * </li>
         * </ul>
         * <p>
         * IN_PROGRESS
         * </p>
         * <ul>
         * <li>
         * <p>
         * The system is creating the rule-based matching rule. Under this status, the system is evaluating the existing
         * data and you can no longer change the Rule-based matching configuration.
         * </p>
         * </li>
         * </ul>
         * <p>
         * ACTIVE
         * </p>
         * <ul>
         * <li>
         * <p>
         * The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        PENDING</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first status after configuration a rule-based matching rule. If it is an existing domain, the
         *        rule-based Identity Resolution waits one hour before creating the matching rule. If it is a new
         *        domain, the system will skip the <code>PENDING</code> stage.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        IN_PROGRESS
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The system is creating the rule-based matching rule. Under this status, the system is evaluating the
         *        existing data and you can no longer change the Rule-based matching configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        ACTIVE
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
         *        </p>
         *        </li>
         * @see RuleBasedMatchingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBasedMatchingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * PENDING
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first status after configuration a rule-based matching rule. If it is an existing domain, the rule-based
         * Identity Resolution waits one hour before creating the matching rule. If it is a new domain, the system will
         * skip the <code>PENDING</code> stage.
         * </p>
         * </li>
         * </ul>
         * <p>
         * IN_PROGRESS
         * </p>
         * <ul>
         * <li>
         * <p>
         * The system is creating the rule-based matching rule. Under this status, the system is evaluating the existing
         * data and you can no longer change the Rule-based matching configuration.
         * </p>
         * </li>
         * </ul>
         * <p>
         * ACTIVE
         * </p>
         * <ul>
         * <li>
         * <p>
         * The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        PENDING</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first status after configuration a rule-based matching rule. If it is an existing domain, the
         *        rule-based Identity Resolution waits one hour before creating the matching rule. If it is a new
         *        domain, the system will skip the <code>PENDING</code> stage.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        IN_PROGRESS
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The system is creating the rule-based matching rule. Under this status, the system is evaluating the
         *        existing data and you can no longer change the Rule-based matching configuration.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        ACTIVE
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The rule is ready to use. You can change the rule a day after the status is in <code>ACTIVE</code>.
         *        </p>
         *        </li>
         * @see RuleBasedMatchingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBasedMatchingStatus
         */
        Builder status(RuleBasedMatchingStatus status);

        /**
         * <p>
         * <a
         * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html">MatchingRule<
         * /a>
         * </p>
         * 
         * @param maxAllowedRuleLevelForMerging
         *        <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html">
         *        MatchingRule</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging);

        /**
         * <p>
         * Indicates the maximum allowed rule level.
         * </p>
         * 
         * @param maxAllowedRuleLevelForMatching
         *        Indicates the maximum allowed rule level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching);

        /**
         * <p>
         * Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution
         * uses to match profiles.
         * </p>
         * 
         * @param attributeTypesSelector
         *        Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity
         *        resolution uses to match profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeTypesSelector(AttributeTypesSelector attributeTypesSelector);

        /**
         * <p>
         * Configures information about the <code>AttributeTypesSelector</code> where the rule-based identity resolution
         * uses to match profiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link AttributeTypesSelector.Builder} avoiding
         * the need to create one manually via {@link AttributeTypesSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AttributeTypesSelector.Builder#build()} is called immediately and
         * its result is passed to {@link #attributeTypesSelector(AttributeTypesSelector)}.
         * 
         * @param attributeTypesSelector
         *        a consumer that will call methods on {@link AttributeTypesSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeTypesSelector(AttributeTypesSelector)
         */
        default Builder attributeTypesSelector(Consumer<AttributeTypesSelector.Builder> attributeTypesSelector) {
            return attributeTypesSelector(AttributeTypesSelector.builder().applyMutation(attributeTypesSelector).build());
        }

        /**
         * Sets the value of the ConflictResolution property for this object.
         *
         * @param conflictResolution
         *        The new value for the ConflictResolution property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conflictResolution(ConflictResolution conflictResolution);

        /**
         * Sets the value of the ConflictResolution property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConflictResolution.Builder} avoiding the
         * need to create one manually via {@link ConflictResolution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConflictResolution.Builder#build()} is called immediately and its
         * result is passed to {@link #conflictResolution(ConflictResolution)}.
         * 
         * @param conflictResolution
         *        a consumer that will call methods on {@link ConflictResolution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conflictResolution(ConflictResolution)
         */
        default Builder conflictResolution(Consumer<ConflictResolution.Builder> conflictResolution) {
            return conflictResolution(ConflictResolution.builder().applyMutation(conflictResolution).build());
        }

        /**
         * Sets the value of the ExportingConfig property for this object.
         *
         * @param exportingConfig
         *        The new value for the ExportingConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingConfig(ExportingConfig exportingConfig);

        /**
         * Sets the value of the ExportingConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ExportingConfig.Builder} avoiding the
         * need to create one manually via {@link ExportingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportingConfig(ExportingConfig)}.
         * 
         * @param exportingConfig
         *        a consumer that will call methods on {@link ExportingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportingConfig(ExportingConfig)
         */
        default Builder exportingConfig(Consumer<ExportingConfig.Builder> exportingConfig) {
            return exportingConfig(ExportingConfig.builder().applyMutation(exportingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<MatchingRule> matchingRules = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Integer maxAllowedRuleLevelForMerging;

        private Integer maxAllowedRuleLevelForMatching;

        private AttributeTypesSelector attributeTypesSelector;

        private ConflictResolution conflictResolution;

        private ExportingConfig exportingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBasedMatchingResponse model) {
            enabled(model.enabled);
            matchingRules(model.matchingRules);
            status(model.status);
            maxAllowedRuleLevelForMerging(model.maxAllowedRuleLevelForMerging);
            maxAllowedRuleLevelForMatching(model.maxAllowedRuleLevelForMatching);
            attributeTypesSelector(model.attributeTypesSelector);
            conflictResolution(model.conflictResolution);
            exportingConfig(model.exportingConfig);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final List<MatchingRule.Builder> getMatchingRules() {
            List<MatchingRule.Builder> result = MatchingRulesCopier.copyToBuilder(this.matchingRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatchingRules(Collection<MatchingRule.BuilderImpl> matchingRules) {
            this.matchingRules = MatchingRulesCopier.copyFromBuilder(matchingRules);
        }

        @Override
        public final Builder matchingRules(Collection<MatchingRule> matchingRules) {
            this.matchingRules = MatchingRulesCopier.copy(matchingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRules(MatchingRule... matchingRules) {
            matchingRules(Arrays.asList(matchingRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchingRules(Consumer<MatchingRule.Builder>... matchingRules) {
            matchingRules(Stream.of(matchingRules).map(c -> MatchingRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RuleBasedMatchingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxAllowedRuleLevelForMerging() {
            return maxAllowedRuleLevelForMerging;
        }

        public final void setMaxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
            this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
        }

        @Override
        public final Builder maxAllowedRuleLevelForMerging(Integer maxAllowedRuleLevelForMerging) {
            this.maxAllowedRuleLevelForMerging = maxAllowedRuleLevelForMerging;
            return this;
        }

        public final Integer getMaxAllowedRuleLevelForMatching() {
            return maxAllowedRuleLevelForMatching;
        }

        public final void setMaxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
            this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
        }

        @Override
        public final Builder maxAllowedRuleLevelForMatching(Integer maxAllowedRuleLevelForMatching) {
            this.maxAllowedRuleLevelForMatching = maxAllowedRuleLevelForMatching;
            return this;
        }

        public final AttributeTypesSelector.Builder getAttributeTypesSelector() {
            return attributeTypesSelector != null ? attributeTypesSelector.toBuilder() : null;
        }

        public final void setAttributeTypesSelector(AttributeTypesSelector.BuilderImpl attributeTypesSelector) {
            this.attributeTypesSelector = attributeTypesSelector != null ? attributeTypesSelector.build() : null;
        }

        @Override
        public final Builder attributeTypesSelector(AttributeTypesSelector attributeTypesSelector) {
            this.attributeTypesSelector = attributeTypesSelector;
            return this;
        }

        public final ConflictResolution.Builder getConflictResolution() {
            return conflictResolution != null ? conflictResolution.toBuilder() : null;
        }

        public final void setConflictResolution(ConflictResolution.BuilderImpl conflictResolution) {
            this.conflictResolution = conflictResolution != null ? conflictResolution.build() : null;
        }

        @Override
        public final Builder conflictResolution(ConflictResolution conflictResolution) {
            this.conflictResolution = conflictResolution;
            return this;
        }

        public final ExportingConfig.Builder getExportingConfig() {
            return exportingConfig != null ? exportingConfig.toBuilder() : null;
        }

        public final void setExportingConfig(ExportingConfig.BuilderImpl exportingConfig) {
            this.exportingConfig = exportingConfig != null ? exportingConfig.build() : null;
        }

        @Override
        public final Builder exportingConfig(ExportingConfig exportingConfig) {
            this.exportingConfig = exportingConfig;
            return this;
        }

        @Override
        public RuleBasedMatchingResponse build() {
            return new RuleBasedMatchingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
