/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.MatchType;
import software.amazon.awssdk.services.customerprofiles.model.ProfileIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSimilarProfilesResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetSimilarProfilesResponse> {
    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileIds").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::profileIds)).setter(GetSimilarProfilesResponse.setter(Builder::profileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchId").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::matchId)).setter(GetSimilarProfilesResponse.setter(Builder::matchId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchId").build()}).build();
    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchType").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::matchTypeAsString)).setter(GetSimilarProfilesResponse.setter(Builder::matchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()}).build();
    private static final SdkField<Integer> RULE_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RuleLevel").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::ruleLevel)).setter(GetSimilarProfilesResponse.setter(Builder::ruleLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleLevel").build()}).build();
    private static final SdkField<Double> CONFIDENCE_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ConfidenceScore").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::confidenceScore)).setter(GetSimilarProfilesResponse.setter(Builder::confidenceScore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfidenceScore").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetSimilarProfilesResponse.getter(GetSimilarProfilesResponse::nextToken)).setter(GetSimilarProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_IDS_FIELD, MATCH_ID_FIELD, MATCH_TYPE_FIELD, RULE_LEVEL_FIELD, CONFIDENCE_SCORE_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> profileIds;
    private final String matchId;
    private final String matchType;
    private final Integer ruleLevel;
    private final Double confidenceScore;
    private final String nextToken;

    private GetSimilarProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.profileIds = builder.profileIds;
        this.matchId = builder.matchId;
        this.matchType = builder.matchType;
        this.ruleLevel = builder.ruleLevel;
        this.confidenceScore = builder.confidenceScore;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasProfileIds() {
        return this.profileIds != null && !(this.profileIds instanceof SdkAutoConstructList);
    }

    public final List<String> profileIds() {
        return this.profileIds;
    }

    public final String matchId() {
        return this.matchId;
    }

    public final MatchType matchType() {
        return MatchType.fromValue(this.matchType);
    }

    public final String matchTypeAsString() {
        return this.matchType;
    }

    public final Integer ruleLevel() {
        return this.ruleLevel;
    }

    public final Double confidenceScore() {
        return this.confidenceScore;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileIds() ? this.profileIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.matchId());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSimilarProfilesResponse)) {
            return false;
        }
        GetSimilarProfilesResponse other = (GetSimilarProfilesResponse)((Object)obj);
        return this.hasProfileIds() == other.hasProfileIds() && Objects.equals(this.profileIds(), other.profileIds()) && Objects.equals(this.matchId(), other.matchId()) && Objects.equals(this.matchTypeAsString(), other.matchTypeAsString()) && Objects.equals(this.ruleLevel(), other.ruleLevel()) && Objects.equals(this.confidenceScore(), other.confidenceScore()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetSimilarProfilesResponse").add("ProfileIds", this.hasProfileIds() ? this.profileIds() : null).add("MatchId", (Object)this.matchId()).add("MatchType", (Object)this.matchTypeAsString()).add("RuleLevel", (Object)this.ruleLevel()).add("ConfidenceScore", (Object)this.confidenceScore()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileIds": {
                return Optional.ofNullable(clazz.cast(this.profileIds()));
            }
            case "MatchId": {
                return Optional.ofNullable(clazz.cast(this.matchId()));
            }
            case "MatchType": {
                return Optional.ofNullable(clazz.cast(this.matchTypeAsString()));
            }
            case "RuleLevel": {
                return Optional.ofNullable(clazz.cast(this.ruleLevel()));
            }
            case "ConfidenceScore": {
                return Optional.ofNullable(clazz.cast(this.confidenceScore()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSimilarProfilesResponse, T> g) {
        return obj -> g.apply((GetSimilarProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();
        private String matchId;
        private String matchType;
        private Integer ruleLevel;
        private Double confidenceScore;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSimilarProfilesResponse model) {
            super(model);
            this.profileIds(model.profileIds);
            this.matchId(model.matchId);
            this.matchType(model.matchType);
            this.ruleLevel(model.ruleLevel);
            this.confidenceScore(model.confidenceScore);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getProfileIds() {
            if (this.profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String ... profileIds) {
            this.profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final String getMatchId() {
            return this.matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final String getMatchType() {
            return this.matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final Integer getRuleLevel() {
            return this.ruleLevel;
        }

        public final void setRuleLevel(Integer ruleLevel) {
            this.ruleLevel = ruleLevel;
        }

        @Override
        public final Builder ruleLevel(Integer ruleLevel) {
            this.ruleLevel = ruleLevel;
            return this;
        }

        public final Double getConfidenceScore() {
            return this.confidenceScore;
        }

        public final void setConfidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
        }

        @Override
        public final Builder confidenceScore(Double confidenceScore) {
            this.confidenceScore = confidenceScore;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetSimilarProfilesResponse build() {
            return new GetSimilarProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSimilarProfilesResponse> {
        public Builder profileIds(Collection<String> var1);

        public Builder profileIds(String ... var1);

        public Builder matchId(String var1);

        public Builder matchType(String var1);

        public Builder matchType(MatchType var1);

        public Builder ruleLevel(Integer var1);

        public Builder confidenceScore(Double var1);

        public Builder nextToken(String var1);
    }
}

