/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MatchType {
    RULE_BASED_MATCHING("RULE_BASED_MATCHING"),
    ML_BASED_MATCHING("ML_BASED_MATCHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatchType> VALUE_MAP;
    private final String value;

    private MatchType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatchType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatchType> knownValues() {
        EnumSet<MatchType> knownValues = EnumSet.allOf(MatchType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MatchType.class, MatchType::toString);
    }
}

