/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompressionTypeValue {
    NONE("none"),
    GZIP("gzip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompressionTypeValue> VALUE_MAP;
    private final String value;

    private CompressionTypeValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionTypeValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionTypeValue> knownValues() {
        EnumSet<CompressionTypeValue> knownValues = EnumSet.allOf(CompressionTypeValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompressionTypeValue.class, CompressionTypeValue::toString);
    }
}

