/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetDbType {
    SPECIFIC_DATABASE("specific-database"),
    MULTIPLE_DATABASES("multiple-databases"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetDbType> VALUE_MAP;
    private final String value;

    private TargetDbType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetDbType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetDbType> knownValues() {
        EnumSet<TargetDbType> knownValues = EnumSet.allOf(TargetDbType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetDbType.class, TargetDbType::toString);
    }
}

