/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VersionStatus {
    UP_TO_DATE("UP_TO_DATE"),
    OUTDATED("OUTDATED"),
    UNSUPPORTED("UNSUPPORTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VersionStatus> VALUE_MAP;
    private final String value;

    private VersionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VersionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VersionStatus> knownValues() {
        EnumSet<VersionStatus> knownValues = EnumSet.allOf(VersionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VersionStatus.class, VersionStatus::toString);
    }
}

