/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportMetadataModelAssessmentResultEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportMetadataModelAssessmentResultEntry> {
    private static final SdkField<String> S3_OBJECT_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ObjectKey").getter(ExportMetadataModelAssessmentResultEntry.getter(ExportMetadataModelAssessmentResultEntry::s3ObjectKey)).setter(ExportMetadataModelAssessmentResultEntry.setter(Builder::s3ObjectKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectKey").build()}).build();
    private static final SdkField<String> OBJECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectURL").getter(ExportMetadataModelAssessmentResultEntry.getter(ExportMetadataModelAssessmentResultEntry::objectURL)).setter(ExportMetadataModelAssessmentResultEntry.setter(Builder::objectURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectURL").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OBJECT_KEY_FIELD, OBJECT_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3ObjectKey;
    private final String objectURL;

    private ExportMetadataModelAssessmentResultEntry(BuilderImpl builder) {
        this.s3ObjectKey = builder.s3ObjectKey;
        this.objectURL = builder.objectURL;
    }

    public final String s3ObjectKey() {
        return this.s3ObjectKey;
    }

    public final String objectURL() {
        return this.objectURL;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectURL());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportMetadataModelAssessmentResultEntry)) {
            return false;
        }
        ExportMetadataModelAssessmentResultEntry other = (ExportMetadataModelAssessmentResultEntry)obj;
        return Objects.equals(this.s3ObjectKey(), other.s3ObjectKey()) && Objects.equals(this.objectURL(), other.objectURL());
    }

    public final String toString() {
        return ToString.builder((String)"ExportMetadataModelAssessmentResultEntry").add("S3ObjectKey", (Object)this.s3ObjectKey()).add("ObjectURL", (Object)this.objectURL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3ObjectKey": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectKey()));
            }
            case "ObjectURL": {
                return Optional.ofNullable(clazz.cast(this.objectURL()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportMetadataModelAssessmentResultEntry, T> g) {
        return obj -> g.apply((ExportMetadataModelAssessmentResultEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3ObjectKey;
        private String objectURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportMetadataModelAssessmentResultEntry model) {
            this.s3ObjectKey(model.s3ObjectKey);
            this.objectURL(model.objectURL);
        }

        public final String getS3ObjectKey() {
            return this.s3ObjectKey;
        }

        public final void setS3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
        }

        @Override
        public final Builder s3ObjectKey(String s3ObjectKey) {
            this.s3ObjectKey = s3ObjectKey;
            return this;
        }

        public final String getObjectURL() {
            return this.objectURL;
        }

        public final void setObjectURL(String objectURL) {
            this.objectURL = objectURL;
        }

        @Override
        public final Builder objectURL(String objectURL) {
            this.objectURL = objectURL;
            return this;
        }

        public ExportMetadataModelAssessmentResultEntry build() {
            return new ExportMetadataModelAssessmentResultEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportMetadataModelAssessmentResultEntry> {
        public Builder s3ObjectKey(String var1);

        public Builder objectURL(String var1);
    }
}

