/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.InstanceProfile;
import software.amazon.awssdk.services.databasemigration.model.InstanceProfileListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceProfilesResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeInstanceProfilesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeInstanceProfilesResponse.getter(DescribeInstanceProfilesResponse::marker)).setter(DescribeInstanceProfilesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceProfiles").getter(DescribeInstanceProfilesResponse.getter(DescribeInstanceProfilesResponse::instanceProfiles)).setter(DescribeInstanceProfilesResponse.setter(Builder::instanceProfiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, INSTANCE_PROFILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeInstanceProfilesResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<InstanceProfile> instanceProfiles;

    private DescribeInstanceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.instanceProfiles = builder.instanceProfiles;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasInstanceProfiles() {
        return this.instanceProfiles != null && !(this.instanceProfiles instanceof SdkAutoConstructList);
    }

    public final List<InstanceProfile> instanceProfiles() {
        return this.instanceProfiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceProfiles() ? this.instanceProfiles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceProfilesResponse)) {
            return false;
        }
        DescribeInstanceProfilesResponse other = (DescribeInstanceProfilesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasInstanceProfiles() == other.hasInstanceProfiles() && Objects.equals(this.instanceProfiles(), other.instanceProfiles());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceProfilesResponse").add("Marker", (Object)this.marker()).add("InstanceProfiles", this.hasInstanceProfiles() ? this.instanceProfiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "InstanceProfiles": {
                return Optional.ofNullable(clazz.cast(this.instanceProfiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("InstanceProfiles", INSTANCE_PROFILES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceProfilesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<InstanceProfile> instanceProfiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceProfilesResponse model) {
            super(model);
            this.marker(model.marker);
            this.instanceProfiles(model.instanceProfiles);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<InstanceProfile.Builder> getInstanceProfiles() {
            List<InstanceProfile.Builder> result = InstanceProfileListCopier.copyToBuilder(this.instanceProfiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceProfiles(Collection<InstanceProfile.BuilderImpl> instanceProfiles) {
            this.instanceProfiles = InstanceProfileListCopier.copyFromBuilder(instanceProfiles);
        }

        @Override
        public final Builder instanceProfiles(Collection<InstanceProfile> instanceProfiles) {
            this.instanceProfiles = InstanceProfileListCopier.copy(instanceProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(InstanceProfile ... instanceProfiles) {
            this.instanceProfiles(Arrays.asList(instanceProfiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... instanceProfiles) {
            this.instanceProfiles(Stream.of(instanceProfiles).map(c -> (InstanceProfile)((InstanceProfile.Builder)InstanceProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeInstanceProfilesResponse build() {
            return new DescribeInstanceProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceProfilesResponse> {
        public Builder marker(String var1);

        public Builder instanceProfiles(Collection<InstanceProfile> var1);

        public Builder instanceProfiles(InstanceProfile ... var1);

        public Builder instanceProfiles(Consumer<InstanceProfile.Builder> ... var1);
    }
}

