/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.RecommendationData;
import software.amazon.awssdk.services.databasemigration.model.RecommendationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<String> DATABASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseId").getter(Recommendation.getter(Recommendation::databaseId)).setter(Recommendation.setter(Builder::databaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseId").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineName").getter(Recommendation.getter(Recommendation::engineName)).setter(Recommendation.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedDate").getter(Recommendation.getter(Recommendation::createdDate)).setter(Recommendation.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Recommendation.getter(Recommendation::status)).setter(Recommendation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> PREFERRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Preferred").getter(Recommendation.getter(Recommendation::preferred)).setter(Recommendation.setter(Builder::preferred)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preferred").build()}).build();
    private static final SdkField<RecommendationSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Settings").getter(Recommendation.getter(Recommendation::settings)).setter(Recommendation.setter(Builder::settings)).constructor(RecommendationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()}).build();
    private static final SdkField<RecommendationData> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Data").getter(Recommendation.getter(Recommendation::data)).setter(Recommendation.setter(Builder::data)).constructor(RecommendationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_ID_FIELD, ENGINE_NAME_FIELD, CREATED_DATE_FIELD, STATUS_FIELD, PREFERRED_FIELD, SETTINGS_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Recommendation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseId;
    private final String engineName;
    private final String createdDate;
    private final String status;
    private final Boolean preferred;
    private final RecommendationSettings settings;
    private final RecommendationData data;

    private Recommendation(BuilderImpl builder) {
        this.databaseId = builder.databaseId;
        this.engineName = builder.engineName;
        this.createdDate = builder.createdDate;
        this.status = builder.status;
        this.preferred = builder.preferred;
        this.settings = builder.settings;
        this.data = builder.data;
    }

    public final String databaseId() {
        return this.databaseId;
    }

    public final String engineName() {
        return this.engineName;
    }

    public final String createdDate() {
        return this.createdDate;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean preferred() {
        return this.preferred;
    }

    public final RecommendationSettings settings() {
        return this.settings;
    }

    public final RecommendationData data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferred());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.databaseId(), other.databaseId()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.preferred(), other.preferred()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("DatabaseId", (Object)this.databaseId()).add("EngineName", (Object)this.engineName()).add("CreatedDate", (Object)this.createdDate()).add("Status", (Object)this.status()).add("Preferred", (Object)this.preferred()).add("Settings", (Object)this.settings()).add("Data", (Object)this.data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseId": {
                return Optional.ofNullable(clazz.cast(this.databaseId()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Preferred": {
                return Optional.ofNullable(clazz.cast(this.preferred()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseId", DATABASE_ID_FIELD);
        map.put("EngineName", ENGINE_NAME_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Preferred", PREFERRED_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        map.put("Data", DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseId;
        private String engineName;
        private String createdDate;
        private String status;
        private Boolean preferred;
        private RecommendationSettings settings;
        private RecommendationData data;

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.databaseId(model.databaseId);
            this.engineName(model.engineName);
            this.createdDate(model.createdDate);
            this.status(model.status);
            this.preferred(model.preferred);
            this.settings(model.settings);
            this.data(model.data);
        }

        public final String getDatabaseId() {
            return this.databaseId;
        }

        public final void setDatabaseId(String databaseId) {
            this.databaseId = databaseId;
        }

        @Override
        public final Builder databaseId(String databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(String createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(String createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPreferred() {
            return this.preferred;
        }

        public final void setPreferred(Boolean preferred) {
            this.preferred = preferred;
        }

        @Override
        public final Builder preferred(Boolean preferred) {
            this.preferred = preferred;
            return this;
        }

        public final RecommendationSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        public final void setSettings(RecommendationSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(RecommendationSettings settings) {
            this.settings = settings;
            return this;
        }

        public final RecommendationData.Builder getData() {
            return this.data != null ? this.data.toBuilder() : null;
        }

        public final void setData(RecommendationData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(RecommendationData data) {
            this.data = data;
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder databaseId(String var1);

        public Builder engineName(String var1);

        public Builder createdDate(String var1);

        public Builder status(String var1);

        public Builder preferred(Boolean var1);

        public Builder settings(RecommendationSettings var1);

        default public Builder settings(Consumer<RecommendationSettings.Builder> settings) {
            return this.settings((RecommendationSettings)((RecommendationSettings.Builder)RecommendationSettings.builder().applyMutation(settings)).build());
        }

        public Builder data(RecommendationData var1);

        default public Builder data(Consumer<RecommendationData.Builder> data) {
            return this.data((RecommendationData)((RecommendationData.Builder)RecommendationData.builder().applyMutation(data)).build());
        }
    }
}

