/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.MigrationTypeValue;
import software.amazon.awssdk.services.databasemigration.model.PremigrationAssessmentStatus;
import software.amazon.awssdk.services.databasemigration.model.PremigrationAssessmentStatusListCopier;
import software.amazon.awssdk.services.databasemigration.model.ProvisionData;
import software.amazon.awssdk.services.databasemigration.model.ReplicationStats;
import software.amazon.awssdk.services.databasemigration.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Replication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Replication> {
    private static final SdkField<String> REPLICATION_CONFIG_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigIdentifier").getter(Replication.getter(Replication::replicationConfigIdentifier)).setter(Replication.setter(Builder::replicationConfigIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigIdentifier").build()}).build();
    private static final SdkField<String> REPLICATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationConfigArn").getter(Replication.getter(Replication::replicationConfigArn)).setter(Replication.setter(Builder::replicationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfigArn").build()}).build();
    private static final SdkField<String> SOURCE_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEndpointArn").getter(Replication.getter(Replication::sourceEndpointArn)).setter(Replication.setter(Builder::sourceEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEndpointArn").build()}).build();
    private static final SdkField<String> TARGET_ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEndpointArn").getter(Replication.getter(Replication::targetEndpointArn)).setter(Replication.setter(Builder::targetEndpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEndpointArn").build()}).build();
    private static final SdkField<String> REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationType").getter(Replication.getter(Replication::replicationTypeAsString)).setter(Replication.setter(Builder::replicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Replication.getter(Replication::status)).setter(Replication.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ProvisionData> PROVISION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ProvisionData").getter(Replication.getter(Replication::provisionData)).setter(Replication.setter(Builder::provisionData)).constructor(ProvisionData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionData").build()}).build();
    private static final SdkField<List<PremigrationAssessmentStatus>> PREMIGRATION_ASSESSMENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PremigrationAssessmentStatuses").getter(Replication.getter(Replication::premigrationAssessmentStatuses)).setter(Replication.setter(Builder::premigrationAssessmentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PremigrationAssessmentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PremigrationAssessmentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STOP_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StopReason").getter(Replication.getter(Replication::stopReason)).setter(Replication.setter(Builder::stopReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopReason").build()}).build();
    private static final SdkField<List<String>> FAILURE_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailureMessages").getter(Replication.getter(Replication::failureMessages)).setter(Replication.setter(Builder::failureMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReplicationStats> REPLICATION_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationStats").getter(Replication.getter(Replication::replicationStats)).setter(Replication.setter(Builder::replicationStats)).constructor(ReplicationStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationStats").build()}).build();
    private static final SdkField<String> START_REPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartReplicationType").getter(Replication.getter(Replication::startReplicationType)).setter(Replication.setter(Builder::startReplicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartReplicationType").build()}).build();
    private static final SdkField<Instant> CDC_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CdcStartTime").getter(Replication.getter(Replication::cdcStartTime)).setter(Replication.setter(Builder::cdcStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartTime").build()}).build();
    private static final SdkField<String> CDC_START_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStartPosition").getter(Replication.getter(Replication::cdcStartPosition)).setter(Replication.setter(Builder::cdcStartPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStartPosition").build()}).build();
    private static final SdkField<String> CDC_STOP_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CdcStopPosition").getter(Replication.getter(Replication::cdcStopPosition)).setter(Replication.setter(Builder::cdcStopPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdcStopPosition").build()}).build();
    private static final SdkField<String> RECOVERY_CHECKPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryCheckpoint").getter(Replication.getter(Replication::recoveryCheckpoint)).setter(Replication.setter(Builder::recoveryCheckpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryCheckpoint").build()}).build();
    private static final SdkField<Instant> REPLICATION_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationCreateTime").getter(Replication.getter(Replication::replicationCreateTime)).setter(Replication.setter(Builder::replicationCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationCreateTime").build()}).build();
    private static final SdkField<Instant> REPLICATION_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationUpdateTime").getter(Replication.getter(Replication::replicationUpdateTime)).setter(Replication.setter(Builder::replicationUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationUpdateTime").build()}).build();
    private static final SdkField<Instant> REPLICATION_LAST_STOP_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationLastStopTime").getter(Replication.getter(Replication::replicationLastStopTime)).setter(Replication.setter(Builder::replicationLastStopTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationLastStopTime").build()}).build();
    private static final SdkField<Instant> REPLICATION_DEPROVISION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ReplicationDeprovisionTime").getter(Replication.getter(Replication::replicationDeprovisionTime)).setter(Replication.setter(Builder::replicationDeprovisionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationDeprovisionTime").build()}).build();
    private static final SdkField<Boolean> IS_READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsReadOnly").getter(Replication.getter(Replication::isReadOnly)).setter(Replication.setter(Builder::isReadOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsReadOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLICATION_CONFIG_IDENTIFIER_FIELD, REPLICATION_CONFIG_ARN_FIELD, SOURCE_ENDPOINT_ARN_FIELD, TARGET_ENDPOINT_ARN_FIELD, REPLICATION_TYPE_FIELD, STATUS_FIELD, PROVISION_DATA_FIELD, PREMIGRATION_ASSESSMENT_STATUSES_FIELD, STOP_REASON_FIELD, FAILURE_MESSAGES_FIELD, REPLICATION_STATS_FIELD, START_REPLICATION_TYPE_FIELD, CDC_START_TIME_FIELD, CDC_START_POSITION_FIELD, CDC_STOP_POSITION_FIELD, RECOVERY_CHECKPOINT_FIELD, REPLICATION_CREATE_TIME_FIELD, REPLICATION_UPDATE_TIME_FIELD, REPLICATION_LAST_STOP_TIME_FIELD, REPLICATION_DEPROVISION_TIME_FIELD, IS_READ_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Replication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String replicationConfigIdentifier;
    private final String replicationConfigArn;
    private final String sourceEndpointArn;
    private final String targetEndpointArn;
    private final String replicationType;
    private final String status;
    private final ProvisionData provisionData;
    private final List<PremigrationAssessmentStatus> premigrationAssessmentStatuses;
    private final String stopReason;
    private final List<String> failureMessages;
    private final ReplicationStats replicationStats;
    private final String startReplicationType;
    private final Instant cdcStartTime;
    private final String cdcStartPosition;
    private final String cdcStopPosition;
    private final String recoveryCheckpoint;
    private final Instant replicationCreateTime;
    private final Instant replicationUpdateTime;
    private final Instant replicationLastStopTime;
    private final Instant replicationDeprovisionTime;
    private final Boolean isReadOnly;

    private Replication(BuilderImpl builder) {
        this.replicationConfigIdentifier = builder.replicationConfigIdentifier;
        this.replicationConfigArn = builder.replicationConfigArn;
        this.sourceEndpointArn = builder.sourceEndpointArn;
        this.targetEndpointArn = builder.targetEndpointArn;
        this.replicationType = builder.replicationType;
        this.status = builder.status;
        this.provisionData = builder.provisionData;
        this.premigrationAssessmentStatuses = builder.premigrationAssessmentStatuses;
        this.stopReason = builder.stopReason;
        this.failureMessages = builder.failureMessages;
        this.replicationStats = builder.replicationStats;
        this.startReplicationType = builder.startReplicationType;
        this.cdcStartTime = builder.cdcStartTime;
        this.cdcStartPosition = builder.cdcStartPosition;
        this.cdcStopPosition = builder.cdcStopPosition;
        this.recoveryCheckpoint = builder.recoveryCheckpoint;
        this.replicationCreateTime = builder.replicationCreateTime;
        this.replicationUpdateTime = builder.replicationUpdateTime;
        this.replicationLastStopTime = builder.replicationLastStopTime;
        this.replicationDeprovisionTime = builder.replicationDeprovisionTime;
        this.isReadOnly = builder.isReadOnly;
    }

    public final String replicationConfigIdentifier() {
        return this.replicationConfigIdentifier;
    }

    public final String replicationConfigArn() {
        return this.replicationConfigArn;
    }

    public final String sourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public final String targetEndpointArn() {
        return this.targetEndpointArn;
    }

    public final MigrationTypeValue replicationType() {
        return MigrationTypeValue.fromValue(this.replicationType);
    }

    public final String replicationTypeAsString() {
        return this.replicationType;
    }

    public final String status() {
        return this.status;
    }

    public final ProvisionData provisionData() {
        return this.provisionData;
    }

    public final boolean hasPremigrationAssessmentStatuses() {
        return this.premigrationAssessmentStatuses != null && !(this.premigrationAssessmentStatuses instanceof SdkAutoConstructList);
    }

    public final List<PremigrationAssessmentStatus> premigrationAssessmentStatuses() {
        return this.premigrationAssessmentStatuses;
    }

    public final String stopReason() {
        return this.stopReason;
    }

    public final boolean hasFailureMessages() {
        return this.failureMessages != null && !(this.failureMessages instanceof SdkAutoConstructList);
    }

    public final List<String> failureMessages() {
        return this.failureMessages;
    }

    public final ReplicationStats replicationStats() {
        return this.replicationStats;
    }

    public final String startReplicationType() {
        return this.startReplicationType;
    }

    public final Instant cdcStartTime() {
        return this.cdcStartTime;
    }

    public final String cdcStartPosition() {
        return this.cdcStartPosition;
    }

    public final String cdcStopPosition() {
        return this.cdcStopPosition;
    }

    public final String recoveryCheckpoint() {
        return this.recoveryCheckpoint;
    }

    public final Instant replicationCreateTime() {
        return this.replicationCreateTime;
    }

    public final Instant replicationUpdateTime() {
        return this.replicationUpdateTime;
    }

    public final Instant replicationLastStopTime() {
        return this.replicationLastStopTime;
    }

    public final Instant replicationDeprovisionTime() {
        return this.replicationDeprovisionTime;
    }

    public final Boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEndpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPremigrationAssessmentStatuses() ? this.premigrationAssessmentStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stopReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureMessages() ? this.failureMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.startReplicationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStartPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdcStopPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryCheckpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationLastStopTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationDeprovisionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isReadOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Replication)) {
            return false;
        }
        Replication other = (Replication)obj;
        return Objects.equals(this.replicationConfigIdentifier(), other.replicationConfigIdentifier()) && Objects.equals(this.replicationConfigArn(), other.replicationConfigArn()) && Objects.equals(this.sourceEndpointArn(), other.sourceEndpointArn()) && Objects.equals(this.targetEndpointArn(), other.targetEndpointArn()) && Objects.equals(this.replicationTypeAsString(), other.replicationTypeAsString()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.provisionData(), other.provisionData()) && this.hasPremigrationAssessmentStatuses() == other.hasPremigrationAssessmentStatuses() && Objects.equals(this.premigrationAssessmentStatuses(), other.premigrationAssessmentStatuses()) && Objects.equals(this.stopReason(), other.stopReason()) && this.hasFailureMessages() == other.hasFailureMessages() && Objects.equals(this.failureMessages(), other.failureMessages()) && Objects.equals(this.replicationStats(), other.replicationStats()) && Objects.equals(this.startReplicationType(), other.startReplicationType()) && Objects.equals(this.cdcStartTime(), other.cdcStartTime()) && Objects.equals(this.cdcStartPosition(), other.cdcStartPosition()) && Objects.equals(this.cdcStopPosition(), other.cdcStopPosition()) && Objects.equals(this.recoveryCheckpoint(), other.recoveryCheckpoint()) && Objects.equals(this.replicationCreateTime(), other.replicationCreateTime()) && Objects.equals(this.replicationUpdateTime(), other.replicationUpdateTime()) && Objects.equals(this.replicationLastStopTime(), other.replicationLastStopTime()) && Objects.equals(this.replicationDeprovisionTime(), other.replicationDeprovisionTime()) && Objects.equals(this.isReadOnly(), other.isReadOnly());
    }

    public final String toString() {
        return ToString.builder((String)"Replication").add("ReplicationConfigIdentifier", (Object)this.replicationConfigIdentifier()).add("ReplicationConfigArn", (Object)this.replicationConfigArn()).add("SourceEndpointArn", (Object)this.sourceEndpointArn()).add("TargetEndpointArn", (Object)this.targetEndpointArn()).add("ReplicationType", (Object)this.replicationTypeAsString()).add("Status", (Object)this.status()).add("ProvisionData", (Object)this.provisionData()).add("PremigrationAssessmentStatuses", this.hasPremigrationAssessmentStatuses() ? this.premigrationAssessmentStatuses() : null).add("StopReason", (Object)this.stopReason()).add("FailureMessages", this.hasFailureMessages() ? this.failureMessages() : null).add("ReplicationStats", (Object)this.replicationStats()).add("StartReplicationType", (Object)this.startReplicationType()).add("CdcStartTime", (Object)this.cdcStartTime()).add("CdcStartPosition", (Object)this.cdcStartPosition()).add("CdcStopPosition", (Object)this.cdcStopPosition()).add("RecoveryCheckpoint", (Object)this.recoveryCheckpoint()).add("ReplicationCreateTime", (Object)this.replicationCreateTime()).add("ReplicationUpdateTime", (Object)this.replicationUpdateTime()).add("ReplicationLastStopTime", (Object)this.replicationLastStopTime()).add("ReplicationDeprovisionTime", (Object)this.replicationDeprovisionTime()).add("IsReadOnly", (Object)this.isReadOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationConfigIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigIdentifier()));
            }
            case "ReplicationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.replicationConfigArn()));
            }
            case "SourceEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.sourceEndpointArn()));
            }
            case "TargetEndpointArn": {
                return Optional.ofNullable(clazz.cast(this.targetEndpointArn()));
            }
            case "ReplicationType": {
                return Optional.ofNullable(clazz.cast(this.replicationTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ProvisionData": {
                return Optional.ofNullable(clazz.cast(this.provisionData()));
            }
            case "PremigrationAssessmentStatuses": {
                return Optional.ofNullable(clazz.cast(this.premigrationAssessmentStatuses()));
            }
            case "StopReason": {
                return Optional.ofNullable(clazz.cast(this.stopReason()));
            }
            case "FailureMessages": {
                return Optional.ofNullable(clazz.cast(this.failureMessages()));
            }
            case "ReplicationStats": {
                return Optional.ofNullable(clazz.cast(this.replicationStats()));
            }
            case "StartReplicationType": {
                return Optional.ofNullable(clazz.cast(this.startReplicationType()));
            }
            case "CdcStartTime": {
                return Optional.ofNullable(clazz.cast(this.cdcStartTime()));
            }
            case "CdcStartPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStartPosition()));
            }
            case "CdcStopPosition": {
                return Optional.ofNullable(clazz.cast(this.cdcStopPosition()));
            }
            case "RecoveryCheckpoint": {
                return Optional.ofNullable(clazz.cast(this.recoveryCheckpoint()));
            }
            case "ReplicationCreateTime": {
                return Optional.ofNullable(clazz.cast(this.replicationCreateTime()));
            }
            case "ReplicationUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.replicationUpdateTime()));
            }
            case "ReplicationLastStopTime": {
                return Optional.ofNullable(clazz.cast(this.replicationLastStopTime()));
            }
            case "ReplicationDeprovisionTime": {
                return Optional.ofNullable(clazz.cast(this.replicationDeprovisionTime()));
            }
            case "IsReadOnly": {
                return Optional.ofNullable(clazz.cast(this.isReadOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReplicationConfigIdentifier", REPLICATION_CONFIG_IDENTIFIER_FIELD);
        map.put("ReplicationConfigArn", REPLICATION_CONFIG_ARN_FIELD);
        map.put("SourceEndpointArn", SOURCE_ENDPOINT_ARN_FIELD);
        map.put("TargetEndpointArn", TARGET_ENDPOINT_ARN_FIELD);
        map.put("ReplicationType", REPLICATION_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ProvisionData", PROVISION_DATA_FIELD);
        map.put("PremigrationAssessmentStatuses", PREMIGRATION_ASSESSMENT_STATUSES_FIELD);
        map.put("StopReason", STOP_REASON_FIELD);
        map.put("FailureMessages", FAILURE_MESSAGES_FIELD);
        map.put("ReplicationStats", REPLICATION_STATS_FIELD);
        map.put("StartReplicationType", START_REPLICATION_TYPE_FIELD);
        map.put("CdcStartTime", CDC_START_TIME_FIELD);
        map.put("CdcStartPosition", CDC_START_POSITION_FIELD);
        map.put("CdcStopPosition", CDC_STOP_POSITION_FIELD);
        map.put("RecoveryCheckpoint", RECOVERY_CHECKPOINT_FIELD);
        map.put("ReplicationCreateTime", REPLICATION_CREATE_TIME_FIELD);
        map.put("ReplicationUpdateTime", REPLICATION_UPDATE_TIME_FIELD);
        map.put("ReplicationLastStopTime", REPLICATION_LAST_STOP_TIME_FIELD);
        map.put("ReplicationDeprovisionTime", REPLICATION_DEPROVISION_TIME_FIELD);
        map.put("IsReadOnly", IS_READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Replication, T> g) {
        return obj -> g.apply((Replication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replicationConfigIdentifier;
        private String replicationConfigArn;
        private String sourceEndpointArn;
        private String targetEndpointArn;
        private String replicationType;
        private String status;
        private ProvisionData provisionData;
        private List<PremigrationAssessmentStatus> premigrationAssessmentStatuses = DefaultSdkAutoConstructList.getInstance();
        private String stopReason;
        private List<String> failureMessages = DefaultSdkAutoConstructList.getInstance();
        private ReplicationStats replicationStats;
        private String startReplicationType;
        private Instant cdcStartTime;
        private String cdcStartPosition;
        private String cdcStopPosition;
        private String recoveryCheckpoint;
        private Instant replicationCreateTime;
        private Instant replicationUpdateTime;
        private Instant replicationLastStopTime;
        private Instant replicationDeprovisionTime;
        private Boolean isReadOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(Replication model) {
            this.replicationConfigIdentifier(model.replicationConfigIdentifier);
            this.replicationConfigArn(model.replicationConfigArn);
            this.sourceEndpointArn(model.sourceEndpointArn);
            this.targetEndpointArn(model.targetEndpointArn);
            this.replicationType(model.replicationType);
            this.status(model.status);
            this.provisionData(model.provisionData);
            this.premigrationAssessmentStatuses(model.premigrationAssessmentStatuses);
            this.stopReason(model.stopReason);
            this.failureMessages(model.failureMessages);
            this.replicationStats(model.replicationStats);
            this.startReplicationType(model.startReplicationType);
            this.cdcStartTime(model.cdcStartTime);
            this.cdcStartPosition(model.cdcStartPosition);
            this.cdcStopPosition(model.cdcStopPosition);
            this.recoveryCheckpoint(model.recoveryCheckpoint);
            this.replicationCreateTime(model.replicationCreateTime);
            this.replicationUpdateTime(model.replicationUpdateTime);
            this.replicationLastStopTime(model.replicationLastStopTime);
            this.replicationDeprovisionTime(model.replicationDeprovisionTime);
            this.isReadOnly(model.isReadOnly);
        }

        public final String getReplicationConfigIdentifier() {
            return this.replicationConfigIdentifier;
        }

        public final void setReplicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
        }

        @Override
        public final Builder replicationConfigIdentifier(String replicationConfigIdentifier) {
            this.replicationConfigIdentifier = replicationConfigIdentifier;
            return this;
        }

        public final String getReplicationConfigArn() {
            return this.replicationConfigArn;
        }

        public final void setReplicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
        }

        @Override
        public final Builder replicationConfigArn(String replicationConfigArn) {
            this.replicationConfigArn = replicationConfigArn;
            return this;
        }

        public final String getSourceEndpointArn() {
            return this.sourceEndpointArn;
        }

        public final void setSourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
        }

        @Override
        public final Builder sourceEndpointArn(String sourceEndpointArn) {
            this.sourceEndpointArn = sourceEndpointArn;
            return this;
        }

        public final String getTargetEndpointArn() {
            return this.targetEndpointArn;
        }

        public final void setTargetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
        }

        @Override
        public final Builder targetEndpointArn(String targetEndpointArn) {
            this.targetEndpointArn = targetEndpointArn;
            return this;
        }

        public final String getReplicationType() {
            return this.replicationType;
        }

        public final void setReplicationType(String replicationType) {
            this.replicationType = replicationType;
        }

        @Override
        public final Builder replicationType(String replicationType) {
            this.replicationType = replicationType;
            return this;
        }

        @Override
        public final Builder replicationType(MigrationTypeValue replicationType) {
            this.replicationType(replicationType == null ? null : replicationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ProvisionData.Builder getProvisionData() {
            return this.provisionData != null ? this.provisionData.toBuilder() : null;
        }

        public final void setProvisionData(ProvisionData.BuilderImpl provisionData) {
            this.provisionData = provisionData != null ? provisionData.build() : null;
        }

        @Override
        public final Builder provisionData(ProvisionData provisionData) {
            this.provisionData = provisionData;
            return this;
        }

        public final List<PremigrationAssessmentStatus.Builder> getPremigrationAssessmentStatuses() {
            List<PremigrationAssessmentStatus.Builder> result = PremigrationAssessmentStatusListCopier.copyToBuilder(this.premigrationAssessmentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremigrationAssessmentStatuses(Collection<PremigrationAssessmentStatus.BuilderImpl> premigrationAssessmentStatuses) {
            this.premigrationAssessmentStatuses = PremigrationAssessmentStatusListCopier.copyFromBuilder(premigrationAssessmentStatuses);
        }

        @Override
        public final Builder premigrationAssessmentStatuses(Collection<PremigrationAssessmentStatus> premigrationAssessmentStatuses) {
            this.premigrationAssessmentStatuses = PremigrationAssessmentStatusListCopier.copy(premigrationAssessmentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premigrationAssessmentStatuses(PremigrationAssessmentStatus ... premigrationAssessmentStatuses) {
            this.premigrationAssessmentStatuses(Arrays.asList(premigrationAssessmentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premigrationAssessmentStatuses(Consumer<PremigrationAssessmentStatus.Builder> ... premigrationAssessmentStatuses) {
            this.premigrationAssessmentStatuses(Stream.of(premigrationAssessmentStatuses).map(c -> (PremigrationAssessmentStatus)((PremigrationAssessmentStatus.Builder)PremigrationAssessmentStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStopReason() {
            return this.stopReason;
        }

        public final void setStopReason(String stopReason) {
            this.stopReason = stopReason;
        }

        @Override
        public final Builder stopReason(String stopReason) {
            this.stopReason = stopReason;
            return this;
        }

        public final Collection<String> getFailureMessages() {
            if (this.failureMessages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureMessages;
        }

        public final void setFailureMessages(Collection<String> failureMessages) {
            this.failureMessages = StringListCopier.copy(failureMessages);
        }

        @Override
        public final Builder failureMessages(Collection<String> failureMessages) {
            this.failureMessages = StringListCopier.copy(failureMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureMessages(String ... failureMessages) {
            this.failureMessages(Arrays.asList(failureMessages));
            return this;
        }

        public final ReplicationStats.Builder getReplicationStats() {
            return this.replicationStats != null ? this.replicationStats.toBuilder() : null;
        }

        public final void setReplicationStats(ReplicationStats.BuilderImpl replicationStats) {
            this.replicationStats = replicationStats != null ? replicationStats.build() : null;
        }

        @Override
        public final Builder replicationStats(ReplicationStats replicationStats) {
            this.replicationStats = replicationStats;
            return this;
        }

        public final String getStartReplicationType() {
            return this.startReplicationType;
        }

        public final void setStartReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
        }

        @Override
        public final Builder startReplicationType(String startReplicationType) {
            this.startReplicationType = startReplicationType;
            return this;
        }

        public final Instant getCdcStartTime() {
            return this.cdcStartTime;
        }

        public final void setCdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
        }

        @Override
        public final Builder cdcStartTime(Instant cdcStartTime) {
            this.cdcStartTime = cdcStartTime;
            return this;
        }

        public final String getCdcStartPosition() {
            return this.cdcStartPosition;
        }

        public final void setCdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
        }

        @Override
        public final Builder cdcStartPosition(String cdcStartPosition) {
            this.cdcStartPosition = cdcStartPosition;
            return this;
        }

        public final String getCdcStopPosition() {
            return this.cdcStopPosition;
        }

        public final void setCdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
        }

        @Override
        public final Builder cdcStopPosition(String cdcStopPosition) {
            this.cdcStopPosition = cdcStopPosition;
            return this;
        }

        public final String getRecoveryCheckpoint() {
            return this.recoveryCheckpoint;
        }

        public final void setRecoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
        }

        @Override
        public final Builder recoveryCheckpoint(String recoveryCheckpoint) {
            this.recoveryCheckpoint = recoveryCheckpoint;
            return this;
        }

        public final Instant getReplicationCreateTime() {
            return this.replicationCreateTime;
        }

        public final void setReplicationCreateTime(Instant replicationCreateTime) {
            this.replicationCreateTime = replicationCreateTime;
        }

        @Override
        public final Builder replicationCreateTime(Instant replicationCreateTime) {
            this.replicationCreateTime = replicationCreateTime;
            return this;
        }

        public final Instant getReplicationUpdateTime() {
            return this.replicationUpdateTime;
        }

        public final void setReplicationUpdateTime(Instant replicationUpdateTime) {
            this.replicationUpdateTime = replicationUpdateTime;
        }

        @Override
        public final Builder replicationUpdateTime(Instant replicationUpdateTime) {
            this.replicationUpdateTime = replicationUpdateTime;
            return this;
        }

        public final Instant getReplicationLastStopTime() {
            return this.replicationLastStopTime;
        }

        public final void setReplicationLastStopTime(Instant replicationLastStopTime) {
            this.replicationLastStopTime = replicationLastStopTime;
        }

        @Override
        public final Builder replicationLastStopTime(Instant replicationLastStopTime) {
            this.replicationLastStopTime = replicationLastStopTime;
            return this;
        }

        public final Instant getReplicationDeprovisionTime() {
            return this.replicationDeprovisionTime;
        }

        public final void setReplicationDeprovisionTime(Instant replicationDeprovisionTime) {
            this.replicationDeprovisionTime = replicationDeprovisionTime;
        }

        @Override
        public final Builder replicationDeprovisionTime(Instant replicationDeprovisionTime) {
            this.replicationDeprovisionTime = replicationDeprovisionTime;
            return this;
        }

        public final Boolean getIsReadOnly() {
            return this.isReadOnly;
        }

        public final void setIsReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
        }

        @Override
        public final Builder isReadOnly(Boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            return this;
        }

        public Replication build() {
            return new Replication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Replication> {
        public Builder replicationConfigIdentifier(String var1);

        public Builder replicationConfigArn(String var1);

        public Builder sourceEndpointArn(String var1);

        public Builder targetEndpointArn(String var1);

        public Builder replicationType(String var1);

        public Builder replicationType(MigrationTypeValue var1);

        public Builder status(String var1);

        public Builder provisionData(ProvisionData var1);

        default public Builder provisionData(Consumer<ProvisionData.Builder> provisionData) {
            return this.provisionData((ProvisionData)((ProvisionData.Builder)ProvisionData.builder().applyMutation(provisionData)).build());
        }

        public Builder premigrationAssessmentStatuses(Collection<PremigrationAssessmentStatus> var1);

        public Builder premigrationAssessmentStatuses(PremigrationAssessmentStatus ... var1);

        public Builder premigrationAssessmentStatuses(Consumer<PremigrationAssessmentStatus.Builder> ... var1);

        public Builder stopReason(String var1);

        public Builder failureMessages(Collection<String> var1);

        public Builder failureMessages(String ... var1);

        public Builder replicationStats(ReplicationStats var1);

        default public Builder replicationStats(Consumer<ReplicationStats.Builder> replicationStats) {
            return this.replicationStats((ReplicationStats)((ReplicationStats.Builder)ReplicationStats.builder().applyMutation(replicationStats)).build());
        }

        public Builder startReplicationType(String var1);

        public Builder cdcStartTime(Instant var1);

        public Builder cdcStartPosition(String var1);

        public Builder cdcStopPosition(String var1);

        public Builder recoveryCheckpoint(String var1);

        public Builder replicationCreateTime(Instant var1);

        public Builder replicationUpdateTime(Instant var1);

        public Builder replicationLastStopTime(Instant var1);

        public Builder replicationDeprovisionTime(Instant var1);

        public Builder isReadOnly(Boolean var1);
    }
}

