/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.MetadataModelProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMetadataModelCreationRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, StartMetadataModelCreationRequest> {
    private static final SdkField<String> MIGRATION_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MigrationProjectIdentifier").getter(StartMetadataModelCreationRequest.getter(StartMetadataModelCreationRequest::migrationProjectIdentifier)).setter(StartMetadataModelCreationRequest.setter(Builder::migrationProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationProjectIdentifier").build()}).build();
    private static final SdkField<String> SELECTION_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionRules").getter(StartMetadataModelCreationRequest.getter(StartMetadataModelCreationRequest::selectionRules)).setter(StartMetadataModelCreationRequest.setter(Builder::selectionRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionRules").build()}).build();
    private static final SdkField<String> METADATA_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataModelName").getter(StartMetadataModelCreationRequest.getter(StartMetadataModelCreationRequest::metadataModelName)).setter(StartMetadataModelCreationRequest.setter(Builder::metadataModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataModelName").build()}).build();
    private static final SdkField<MetadataModelProperties> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Properties").getter(StartMetadataModelCreationRequest.getter(StartMetadataModelCreationRequest::properties)).setter(StartMetadataModelCreationRequest.setter(Builder::properties)).constructor(MetadataModelProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIGRATION_PROJECT_IDENTIFIER_FIELD, SELECTION_RULES_FIELD, METADATA_MODEL_NAME_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMetadataModelCreationRequest.memberNameToFieldInitializer();
    private final String migrationProjectIdentifier;
    private final String selectionRules;
    private final String metadataModelName;
    private final MetadataModelProperties properties;

    private StartMetadataModelCreationRequest(BuilderImpl builder) {
        super(builder);
        this.migrationProjectIdentifier = builder.migrationProjectIdentifier;
        this.selectionRules = builder.selectionRules;
        this.metadataModelName = builder.metadataModelName;
        this.properties = builder.properties;
    }

    public final String migrationProjectIdentifier() {
        return this.migrationProjectIdentifier;
    }

    public final String selectionRules() {
        return this.selectionRules;
    }

    public final String metadataModelName() {
        return this.metadataModelName;
    }

    public final MetadataModelProperties properties() {
        return this.properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.properties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataModelCreationRequest)) {
            return false;
        }
        StartMetadataModelCreationRequest other = (StartMetadataModelCreationRequest)((Object)obj);
        return Objects.equals(this.migrationProjectIdentifier(), other.migrationProjectIdentifier()) && Objects.equals(this.selectionRules(), other.selectionRules()) && Objects.equals(this.metadataModelName(), other.metadataModelName()) && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"StartMetadataModelCreationRequest").add("MigrationProjectIdentifier", (Object)this.migrationProjectIdentifier()).add("SelectionRules", (Object)this.selectionRules()).add("MetadataModelName", (Object)this.metadataModelName()).add("Properties", (Object)this.properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MigrationProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.migrationProjectIdentifier()));
            }
            case "SelectionRules": {
                return Optional.ofNullable(clazz.cast(this.selectionRules()));
            }
            case "MetadataModelName": {
                return Optional.ofNullable(clazz.cast(this.metadataModelName()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MigrationProjectIdentifier", MIGRATION_PROJECT_IDENTIFIER_FIELD);
        map.put("SelectionRules", SELECTION_RULES_FIELD);
        map.put("MetadataModelName", METADATA_MODEL_NAME_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataModelCreationRequest, T> g) {
        return obj -> g.apply((StartMetadataModelCreationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String migrationProjectIdentifier;
        private String selectionRules;
        private String metadataModelName;
        private MetadataModelProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataModelCreationRequest model) {
            super(model);
            this.migrationProjectIdentifier(model.migrationProjectIdentifier);
            this.selectionRules(model.selectionRules);
            this.metadataModelName(model.metadataModelName);
            this.properties(model.properties);
        }

        public final String getMigrationProjectIdentifier() {
            return this.migrationProjectIdentifier;
        }

        public final void setMigrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
        }

        @Override
        public final Builder migrationProjectIdentifier(String migrationProjectIdentifier) {
            this.migrationProjectIdentifier = migrationProjectIdentifier;
            return this;
        }

        public final String getSelectionRules() {
            return this.selectionRules;
        }

        public final void setSelectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
        }

        @Override
        public final Builder selectionRules(String selectionRules) {
            this.selectionRules = selectionRules;
            return this;
        }

        public final String getMetadataModelName() {
            return this.metadataModelName;
        }

        public final void setMetadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
        }

        @Override
        public final Builder metadataModelName(String metadataModelName) {
            this.metadataModelName = metadataModelName;
            return this;
        }

        public final MetadataModelProperties.Builder getProperties() {
            return this.properties != null ? this.properties.toBuilder() : null;
        }

        public final void setProperties(MetadataModelProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MetadataModelProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataModelCreationRequest build() {
            return new StartMetadataModelCreationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMetadataModelCreationRequest> {
        public Builder migrationProjectIdentifier(String var1);

        public Builder selectionRules(String var1);

        public Builder metadataModelName(String var1);

        public Builder properties(MetadataModelProperties var1);

        default public Builder properties(Consumer<MetadataModelProperties.Builder> properties) {
            return this.properties((MetadataModelProperties)((MetadataModelProperties.Builder)MetadataModelProperties.builder().applyMutation(properties)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

