/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databrew.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.databrew.model.DatasetParameter;
import software.amazon.awssdk.services.databrew.model.FilesLimit;
import software.amazon.awssdk.services.databrew.model.FilterExpression;
import software.amazon.awssdk.services.databrew.model.PathParametersMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PathOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PathOptions> {
    private static final SdkField<FilterExpression> LAST_MODIFIED_DATE_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDateCondition").getter(PathOptions.getter(PathOptions::lastModifiedDateCondition)).setter(PathOptions.setter(Builder::lastModifiedDateCondition)).constructor(FilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDateCondition").build()}).build();
    private static final SdkField<FilesLimit> FILES_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilesLimit").getter(PathOptions.getter(PathOptions::filesLimit)).setter(PathOptions.setter(Builder::filesLimit)).constructor(FilesLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilesLimit").build()}).build();
    private static final SdkField<Map<String, DatasetParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(PathOptions.getter(PathOptions::parameters)).setter(PathOptions.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_DATE_CONDITION_FIELD, FILES_LIMIT_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FilterExpression lastModifiedDateCondition;
    private final FilesLimit filesLimit;
    private final Map<String, DatasetParameter> parameters;

    private PathOptions(BuilderImpl builder) {
        this.lastModifiedDateCondition = builder.lastModifiedDateCondition;
        this.filesLimit = builder.filesLimit;
        this.parameters = builder.parameters;
    }

    public final FilterExpression lastModifiedDateCondition() {
        return this.lastModifiedDateCondition;
    }

    public final FilesLimit filesLimit() {
        return this.filesLimit;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, DatasetParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDateCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.filesLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathOptions)) {
            return false;
        }
        PathOptions other = (PathOptions)obj;
        return Objects.equals(this.lastModifiedDateCondition(), other.lastModifiedDateCondition()) && Objects.equals(this.filesLimit(), other.filesLimit()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"PathOptions").add("LastModifiedDateCondition", (Object)this.lastModifiedDateCondition()).add("FilesLimit", (Object)this.filesLimit()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastModifiedDateCondition": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDateCondition()));
            }
            case "FilesLimit": {
                return Optional.ofNullable(clazz.cast(this.filesLimit()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PathOptions, T> g) {
        return obj -> g.apply((PathOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FilterExpression lastModifiedDateCondition;
        private FilesLimit filesLimit;
        private Map<String, DatasetParameter> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathOptions model) {
            this.lastModifiedDateCondition(model.lastModifiedDateCondition);
            this.filesLimit(model.filesLimit);
            this.parameters(model.parameters);
        }

        public final FilterExpression.Builder getLastModifiedDateCondition() {
            return this.lastModifiedDateCondition != null ? this.lastModifiedDateCondition.toBuilder() : null;
        }

        public final void setLastModifiedDateCondition(FilterExpression.BuilderImpl lastModifiedDateCondition) {
            this.lastModifiedDateCondition = lastModifiedDateCondition != null ? lastModifiedDateCondition.build() : null;
        }

        @Override
        public final Builder lastModifiedDateCondition(FilterExpression lastModifiedDateCondition) {
            this.lastModifiedDateCondition = lastModifiedDateCondition;
            return this;
        }

        public final FilesLimit.Builder getFilesLimit() {
            return this.filesLimit != null ? this.filesLimit.toBuilder() : null;
        }

        public final void setFilesLimit(FilesLimit.BuilderImpl filesLimit) {
            this.filesLimit = filesLimit != null ? filesLimit.build() : null;
        }

        @Override
        public final Builder filesLimit(FilesLimit filesLimit) {
            this.filesLimit = filesLimit;
            return this;
        }

        public final Map<String, DatasetParameter.Builder> getParameters() {
            Map<String, DatasetParameter.Builder> result = PathParametersMapCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, DatasetParameter.BuilderImpl> parameters) {
            this.parameters = PathParametersMapCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, DatasetParameter> parameters) {
            this.parameters = PathParametersMapCopier.copy(parameters);
            return this;
        }

        public PathOptions build() {
            return new PathOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PathOptions> {
        public Builder lastModifiedDateCondition(FilterExpression var1);

        default public Builder lastModifiedDateCondition(Consumer<FilterExpression.Builder> lastModifiedDateCondition) {
            return this.lastModifiedDateCondition((FilterExpression)((FilterExpression.Builder)FilterExpression.builder().applyMutation(lastModifiedDateCondition)).build());
        }

        public Builder filesLimit(FilesLimit var1);

        default public Builder filesLimit(Consumer<FilesLimit.Builder> filesLimit) {
            return this.filesLimit((FilesLimit)((FilesLimit.Builder)FilesLimit.builder().applyMutation(filesLimit)).build());
        }

        public Builder parameters(Map<String, DatasetParameter> var1);
    }
}

