/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dataexchange.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An event action is an object that defines the relationship between a specific event and an automated action that will
 * be taken on behalf of the customer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventActionEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<EventActionEntry.Builder, EventActionEntry> {
    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(EventActionEntry::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(EventActionEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(EventActionEntry::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Event> EVENT_FIELD = SdkField.<Event> builder(MarshallingType.SDK_POJO).memberName("Event")
            .getter(getter(EventActionEntry::event)).setter(setter(Builder::event)).constructor(Event::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Event").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(EventActionEntry::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt")
            .getter(getter(EventActionEntry::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ARN_FIELD,
            CREATED_AT_FIELD, EVENT_FIELD, ID_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Action action;

    private final String arn;

    private final Instant createdAt;

    private final Event event;

    private final String id;

    private final Instant updatedAt;

    private EventActionEntry(BuilderImpl builder) {
        this.action = builder.action;
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.event = builder.event;
        this.id = builder.id;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * What occurs after a certain event.
     * </p>
     * 
     * @return What occurs after a certain event.
     */
    public final Action action() {
        return action;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the event action.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the event action.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time that the event action was created, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the event action was created, in ISO 8601 format.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * What occurs to start an action.
     * </p>
     * 
     * @return What occurs to start an action.
     */
    public final Event event() {
        return event;
    }

    /**
     * <p>
     * The unique identifier for the event action.
     * </p>
     * 
     * @return The unique identifier for the event action.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time that the event action was last updated, in ISO 8601 format.
     * </p>
     * 
     * @return The date and time that the event action was last updated, in ISO 8601 format.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventActionEntry)) {
            return false;
        }
        EventActionEntry other = (EventActionEntry) obj;
        return Objects.equals(action(), other.action()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(event(), other.event())
                && Objects.equals(id(), other.id()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventActionEntry").add("Action", action()).add("Arn", arn()).add("CreatedAt", createdAt())
                .add("Event", event()).add("Id", id()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Event":
            return Optional.ofNullable(clazz.cast(event()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventActionEntry, T> g) {
        return obj -> g.apply((EventActionEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventActionEntry> {
        /**
         * <p>
         * What occurs after a certain event.
         * </p>
         * 
         * @param action
         *        What occurs after a certain event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * What occurs after a certain event.
         * </p>
         * This is a convenience method that creates an instance of the {@link Action.Builder} avoiding the need to
         * create one manually via {@link Action#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the event action.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the event action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time that the event action was created, in ISO 8601 format.
         * </p>
         * 
         * @param createdAt
         *        The date and time that the event action was created, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * What occurs to start an action.
         * </p>
         * 
         * @param event
         *        What occurs to start an action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(Event event);

        /**
         * <p>
         * What occurs to start an action.
         * </p>
         * This is a convenience method that creates an instance of the {@link Event.Builder} avoiding the need to
         * create one manually via {@link Event#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Event.Builder#build()} is called immediately and its result is
         * passed to {@link #event(Event)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link Event.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(Event)
         */
        default Builder event(Consumer<Event.Builder> event) {
            return event(Event.builder().applyMutation(event).build());
        }

        /**
         * <p>
         * The unique identifier for the event action.
         * </p>
         * 
         * @param id
         *        The unique identifier for the event action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time that the event action was last updated, in ISO 8601 format.
         * </p>
         * 
         * @param updatedAt
         *        The date and time that the event action was last updated, in ISO 8601 format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Action action;

        private String arn;

        private Instant createdAt;

        private Event event;

        private String id;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EventActionEntry model) {
            action(model.action);
            arn(model.arn);
            createdAt(model.createdAt);
            event(model.event);
            id(model.id);
            updatedAt(model.updatedAt);
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Event.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(Event.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(Event event) {
            this.event = event;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public EventActionEntry build() {
            return new EventActionEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
