/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.MetadataGenerationRunTarget;
import software.amazon.awssdk.services.datazone.model.MetadataGenerationRunType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMetadataGenerationRunRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, StartMetadataGenerationRunRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartMetadataGenerationRunRequest.getter(StartMetadataGenerationRunRequest::clientToken)).setter(StartMetadataGenerationRunRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(StartMetadataGenerationRunRequest.getter(StartMetadataGenerationRunRequest::domainIdentifier)).setter(StartMetadataGenerationRunRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> OWNING_PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owningProjectIdentifier").getter(StartMetadataGenerationRunRequest.getter(StartMetadataGenerationRunRequest::owningProjectIdentifier)).setter(StartMetadataGenerationRunRequest.setter(Builder::owningProjectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owningProjectIdentifier").build()}).build();
    private static final SdkField<MetadataGenerationRunTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("target").getter(StartMetadataGenerationRunRequest.getter(StartMetadataGenerationRunRequest::target)).setter(StartMetadataGenerationRunRequest.setter(Builder::target)).constructor(MetadataGenerationRunTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(StartMetadataGenerationRunRequest.getter(StartMetadataGenerationRunRequest::typeAsString)).setter(StartMetadataGenerationRunRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, OWNING_PROJECT_IDENTIFIER_FIELD, TARGET_FIELD, TYPE_FIELD));
    private final String clientToken;
    private final String domainIdentifier;
    private final String owningProjectIdentifier;
    private final MetadataGenerationRunTarget target;
    private final String type;

    private StartMetadataGenerationRunRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.owningProjectIdentifier = builder.owningProjectIdentifier;
        this.target = builder.target;
        this.type = builder.type;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String owningProjectIdentifier() {
        return this.owningProjectIdentifier;
    }

    public final MetadataGenerationRunTarget target() {
        return this.target;
    }

    public final MetadataGenerationRunType type() {
        return MetadataGenerationRunType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.owningProjectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMetadataGenerationRunRequest)) {
            return false;
        }
        StartMetadataGenerationRunRequest other = (StartMetadataGenerationRunRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.owningProjectIdentifier(), other.owningProjectIdentifier()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartMetadataGenerationRunRequest").add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("OwningProjectIdentifier", (Object)this.owningProjectIdentifier()).add("Target", (Object)this.target()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "owningProjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.owningProjectIdentifier()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMetadataGenerationRunRequest, T> g) {
        return obj -> g.apply((StartMetadataGenerationRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private String owningProjectIdentifier;
        private MetadataGenerationRunTarget target;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMetadataGenerationRunRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.owningProjectIdentifier(model.owningProjectIdentifier);
            this.target(model.target);
            this.type(model.type);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getOwningProjectIdentifier() {
            return this.owningProjectIdentifier;
        }

        public final void setOwningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
        }

        @Override
        public final Builder owningProjectIdentifier(String owningProjectIdentifier) {
            this.owningProjectIdentifier = owningProjectIdentifier;
            return this;
        }

        public final MetadataGenerationRunTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        public final void setTarget(MetadataGenerationRunTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(MetadataGenerationRunTarget target) {
            this.target = target;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataGenerationRunType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMetadataGenerationRunRequest build() {
            return new StartMetadataGenerationRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMetadataGenerationRunRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder owningProjectIdentifier(String var1);

        public Builder target(MetadataGenerationRunTarget var1);

        default public Builder target(Consumer<MetadataGenerationRunTarget.Builder> target) {
            return this.target((MetadataGenerationRunTarget)((MetadataGenerationRunTarget.Builder)MetadataGenerationRunTarget.builder().applyMutation(target)).build());
        }

        public Builder type(String var1);

        public Builder type(MetadataGenerationRunType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

