/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataProductStatus {
    CREATED("CREATED"),
    CREATING("CREATING"),
    CREATE_FAILED("CREATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataProductStatus> VALUE_MAP;
    private final String value;

    private DataProductStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataProductStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataProductStatus> knownValues() {
        EnumSet<DataProductStatus> knownValues = EnumSet.allOf(DataProductStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataProductStatus.class, DataProductStatus::toString);
    }
}

