/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.FilterExpression;
import software.amazon.awssdk.services.datazone.model.FilterExpressionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelationalFilterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelationalFilterConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(RelationalFilterConfiguration.getter(RelationalFilterConfiguration::databaseName)).setter(RelationalFilterConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<List<FilterExpression>> FILTER_EXPRESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filterExpressions").getter(RelationalFilterConfiguration.getter(RelationalFilterConfiguration::filterExpressions)).setter(RelationalFilterConfiguration.setter(Builder::filterExpressions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpressions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FilterExpression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCHEMA_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("schemaName").getter(RelationalFilterConfiguration.getter(RelationalFilterConfiguration::schemaName)).setter(RelationalFilterConfiguration.setter(Builder::schemaName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, FILTER_EXPRESSIONS_FIELD, SCHEMA_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelationalFilterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String databaseName;
    private final List<FilterExpression> filterExpressions;
    private final String schemaName;

    private RelationalFilterConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.filterExpressions = builder.filterExpressions;
        this.schemaName = builder.schemaName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final boolean hasFilterExpressions() {
        return this.filterExpressions != null && !(this.filterExpressions instanceof SdkAutoConstructList);
    }

    public final List<FilterExpression> filterExpressions() {
        return this.filterExpressions;
    }

    public final String schemaName() {
        return this.schemaName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterExpressions() ? this.filterExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationalFilterConfiguration)) {
            return false;
        }
        RelationalFilterConfiguration other = (RelationalFilterConfiguration)obj;
        return Objects.equals(this.databaseName(), other.databaseName()) && this.hasFilterExpressions() == other.hasFilterExpressions() && Objects.equals(this.filterExpressions(), other.filterExpressions()) && Objects.equals(this.schemaName(), other.schemaName());
    }

    public final String toString() {
        return ToString.builder((String)"RelationalFilterConfiguration").add("DatabaseName", (Object)this.databaseName()).add("FilterExpressions", this.hasFilterExpressions() ? this.filterExpressions() : null).add("SchemaName", (Object)this.schemaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "filterExpressions": {
                return Optional.ofNullable(clazz.cast(this.filterExpressions()));
            }
            case "schemaName": {
                return Optional.ofNullable(clazz.cast(this.schemaName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("filterExpressions", FILTER_EXPRESSIONS_FIELD);
        map.put("schemaName", SCHEMA_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelationalFilterConfiguration, T> g) {
        return obj -> g.apply((RelationalFilterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String databaseName;
        private List<FilterExpression> filterExpressions = DefaultSdkAutoConstructList.getInstance();
        private String schemaName;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationalFilterConfiguration model) {
            this.databaseName(model.databaseName);
            this.filterExpressions(model.filterExpressions);
            this.schemaName(model.schemaName);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final List<FilterExpression.Builder> getFilterExpressions() {
            List<FilterExpression.Builder> result = FilterExpressionsCopier.copyToBuilder(this.filterExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilterExpressions(Collection<FilterExpression.BuilderImpl> filterExpressions) {
            this.filterExpressions = FilterExpressionsCopier.copyFromBuilder(filterExpressions);
        }

        @Override
        public final Builder filterExpressions(Collection<FilterExpression> filterExpressions) {
            this.filterExpressions = FilterExpressionsCopier.copy(filterExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterExpressions(FilterExpression ... filterExpressions) {
            this.filterExpressions(Arrays.asList(filterExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterExpressions(Consumer<FilterExpression.Builder> ... filterExpressions) {
            this.filterExpressions(Stream.of(filterExpressions).map(c -> (FilterExpression)((FilterExpression.Builder)FilterExpression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSchemaName() {
            return this.schemaName;
        }

        public final void setSchemaName(String schemaName) {
            this.schemaName = schemaName;
        }

        @Override
        public final Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public RelationalFilterConfiguration build() {
            return new RelationalFilterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelationalFilterConfiguration> {
        public Builder databaseName(String var1);

        public Builder filterExpressions(Collection<FilterExpression> var1);

        public Builder filterExpressions(FilterExpression ... var1);

        public Builder filterExpressions(Consumer<FilterExpression.Builder> ... var1);

        public Builder schemaName(String var1);
    }
}

