/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolutionStrategy {
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolutionStrategy> VALUE_MAP;
    private final String value;

    private ResolutionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolutionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolutionStrategy> knownValues() {
        EnumSet<ResolutionStrategy> knownValues = EnumSet.allOf(ResolutionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolutionStrategy.class, ResolutionStrategy::toString);
    }
}

