/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AccountInfo;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountsInAccountPoolResponse;

public class ListAccountsInAccountPoolPublisher
implements SdkPublisher<ListAccountsInAccountPoolResponse> {
    private final DataZoneAsyncClient client;
    private final ListAccountsInAccountPoolRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountsInAccountPoolPublisher(DataZoneAsyncClient client, ListAccountsInAccountPoolRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountsInAccountPoolPublisher(DataZoneAsyncClient client, ListAccountsInAccountPoolRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountsInAccountPoolResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountsInAccountPoolResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountInfo> items() {
        Function<ListAccountsInAccountPoolResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountsInAccountPoolResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountsInAccountPoolResponseFetcher
    implements AsyncPageFetcher<ListAccountsInAccountPoolResponse> {
        private ListAccountsInAccountPoolResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountsInAccountPoolResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountsInAccountPoolResponse> nextPage(ListAccountsInAccountPoolResponse previousPage) {
            if (previousPage == null) {
                return ListAccountsInAccountPoolPublisher.this.client.listAccountsInAccountPool(ListAccountsInAccountPoolPublisher.this.firstRequest);
            }
            return ListAccountsInAccountPoolPublisher.this.client.listAccountsInAccountPool((ListAccountsInAccountPoolRequest)((Object)ListAccountsInAccountPoolPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

