/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IsModifiable {
    TRUE("TRUE"),
    FALSE("FALSE"),
    CONDITIONAL("CONDITIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IsModifiable> VALUE_MAP;
    private final String value;

    private IsModifiable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IsModifiable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IsModifiable> knownValues() {
        EnumSet<IsModifiable> knownValues = EnumSet.allOf(IsModifiable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IsModifiable.class, IsModifiable::toString);
    }
}

