/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.detective.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information on the usage of a data source package in the behavior graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasourcePackageUsageInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasourcePackageUsageInfo.Builder, DatasourcePackageUsageInfo> {
    private static final SdkField<Long> VOLUME_USAGE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("VolumeUsageInBytes").getter(getter(DatasourcePackageUsageInfo::volumeUsageInBytes))
            .setter(setter(Builder::volumeUsageInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageInBytes").build())
            .build();

    private static final SdkField<Instant> VOLUME_USAGE_UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("VolumeUsageUpdateTime")
            .getter(getter(DatasourcePackageUsageInfo::volumeUsageUpdateTime))
            .setter(setter(Builder::volumeUsageUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeUsageUpdateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_USAGE_IN_BYTES_FIELD,
            VOLUME_USAGE_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long volumeUsageInBytes;

    private final Instant volumeUsageUpdateTime;

    private DatasourcePackageUsageInfo(BuilderImpl builder) {
        this.volumeUsageInBytes = builder.volumeUsageInBytes;
        this.volumeUsageUpdateTime = builder.volumeUsageUpdateTime;
    }

    /**
     * <p>
     * Total volume of data in bytes per day ingested for a given data source package.
     * </p>
     * 
     * @return Total volume of data in bytes per day ingested for a given data source package.
     */
    public final Long volumeUsageInBytes() {
        return volumeUsageInBytes;
    }

    /**
     * <p>
     * The data and time when the member account data volume was last updated. The value is an ISO8601 formatted string.
     * For example, <code>2021-08-18T16:35:56.284Z</code>.
     * </p>
     * 
     * @return The data and time when the member account data volume was last updated. The value is an ISO8601 formatted
     *         string. For example, <code>2021-08-18T16:35:56.284Z</code>.
     */
    public final Instant volumeUsageUpdateTime() {
        return volumeUsageUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeUsageInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(volumeUsageUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasourcePackageUsageInfo)) {
            return false;
        }
        DatasourcePackageUsageInfo other = (DatasourcePackageUsageInfo) obj;
        return Objects.equals(volumeUsageInBytes(), other.volumeUsageInBytes())
                && Objects.equals(volumeUsageUpdateTime(), other.volumeUsageUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasourcePackageUsageInfo").add("VolumeUsageInBytes", volumeUsageInBytes())
                .add("VolumeUsageUpdateTime", volumeUsageUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeUsageInBytes":
            return Optional.ofNullable(clazz.cast(volumeUsageInBytes()));
        case "VolumeUsageUpdateTime":
            return Optional.ofNullable(clazz.cast(volumeUsageUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasourcePackageUsageInfo, T> g) {
        return obj -> g.apply((DatasourcePackageUsageInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasourcePackageUsageInfo> {
        /**
         * <p>
         * Total volume of data in bytes per day ingested for a given data source package.
         * </p>
         * 
         * @param volumeUsageInBytes
         *        Total volume of data in bytes per day ingested for a given data source package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeUsageInBytes(Long volumeUsageInBytes);

        /**
         * <p>
         * The data and time when the member account data volume was last updated. The value is an ISO8601 formatted
         * string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * </p>
         * 
         * @param volumeUsageUpdateTime
         *        The data and time when the member account data volume was last updated. The value is an ISO8601
         *        formatted string. For example, <code>2021-08-18T16:35:56.284Z</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeUsageUpdateTime(Instant volumeUsageUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private Long volumeUsageInBytes;

        private Instant volumeUsageUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasourcePackageUsageInfo model) {
            volumeUsageInBytes(model.volumeUsageInBytes);
            volumeUsageUpdateTime(model.volumeUsageUpdateTime);
        }

        public final Long getVolumeUsageInBytes() {
            return volumeUsageInBytes;
        }

        public final void setVolumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
        }

        @Override
        public final Builder volumeUsageInBytes(Long volumeUsageInBytes) {
            this.volumeUsageInBytes = volumeUsageInBytes;
            return this;
        }

        public final Instant getVolumeUsageUpdateTime() {
            return volumeUsageUpdateTime;
        }

        public final void setVolumeUsageUpdateTime(Instant volumeUsageUpdateTime) {
            this.volumeUsageUpdateTime = volumeUsageUpdateTime;
        }

        @Override
        public final Builder volumeUsageUpdateTime(Instant volumeUsageUpdateTime) {
            this.volumeUsageUpdateTime = volumeUsageUpdateTime;
            return this;
        }

        @Override
        public DatasourcePackageUsageInfo build() {
            return new DatasourcePackageUsageInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
