/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.devicefarm.model.DeviceFarmRequest;
import software.amazon.awssdk.services.devicefarm.model.PackageIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInstanceProfileRequest
extends DeviceFarmRequest
implements ToCopyableBuilder<Builder, CreateInstanceProfileRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::name)).setter(CreateInstanceProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::description)).setter(CreateInstanceProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> PACKAGE_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("packageCleanup").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::packageCleanup)).setter(CreateInstanceProfileRequest.setter(Builder::packageCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageCleanup").build()}).build();
    private static final SdkField<List<String>> EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludeAppPackagesFromCleanup").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::excludeAppPackagesFromCleanup)).setter(CreateInstanceProfileRequest.setter(Builder::excludeAppPackagesFromCleanup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeAppPackagesFromCleanup").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> REBOOT_AFTER_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rebootAfterUse").getter(CreateInstanceProfileRequest.getter(CreateInstanceProfileRequest::rebootAfterUse)).setter(CreateInstanceProfileRequest.setter(Builder::rebootAfterUse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rebootAfterUse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, PACKAGE_CLEANUP_FIELD, EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD, REBOOT_AFTER_USE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInstanceProfileRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final Boolean packageCleanup;
    private final List<String> excludeAppPackagesFromCleanup;
    private final Boolean rebootAfterUse;

    private CreateInstanceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.packageCleanup = builder.packageCleanup;
        this.excludeAppPackagesFromCleanup = builder.excludeAppPackagesFromCleanup;
        this.rebootAfterUse = builder.rebootAfterUse;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean packageCleanup() {
        return this.packageCleanup;
    }

    public final boolean hasExcludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup != null && !(this.excludeAppPackagesFromCleanup instanceof SdkAutoConstructList);
    }

    public final List<String> excludeAppPackagesFromCleanup() {
        return this.excludeAppPackagesFromCleanup;
    }

    public final Boolean rebootAfterUse() {
        return this.rebootAfterUse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageCleanup());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludeAppPackagesFromCleanup() ? this.excludeAppPackagesFromCleanup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.rebootAfterUse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceProfileRequest)) {
            return false;
        }
        CreateInstanceProfileRequest other = (CreateInstanceProfileRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.packageCleanup(), other.packageCleanup()) && this.hasExcludeAppPackagesFromCleanup() == other.hasExcludeAppPackagesFromCleanup() && Objects.equals(this.excludeAppPackagesFromCleanup(), other.excludeAppPackagesFromCleanup()) && Objects.equals(this.rebootAfterUse(), other.rebootAfterUse());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInstanceProfileRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("PackageCleanup", (Object)this.packageCleanup()).add("ExcludeAppPackagesFromCleanup", this.hasExcludeAppPackagesFromCleanup() ? this.excludeAppPackagesFromCleanup() : null).add("RebootAfterUse", (Object)this.rebootAfterUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "packageCleanup": {
                return Optional.ofNullable(clazz.cast(this.packageCleanup()));
            }
            case "excludeAppPackagesFromCleanup": {
                return Optional.ofNullable(clazz.cast(this.excludeAppPackagesFromCleanup()));
            }
            case "rebootAfterUse": {
                return Optional.ofNullable(clazz.cast(this.rebootAfterUse()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("packageCleanup", PACKAGE_CLEANUP_FIELD);
        map.put("excludeAppPackagesFromCleanup", EXCLUDE_APP_PACKAGES_FROM_CLEANUP_FIELD);
        map.put("rebootAfterUse", REBOOT_AFTER_USE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceProfileRequest, T> g) {
        return obj -> g.apply((CreateInstanceProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeviceFarmRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Boolean packageCleanup;
        private List<String> excludeAppPackagesFromCleanup = DefaultSdkAutoConstructList.getInstance();
        private Boolean rebootAfterUse;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceProfileRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.packageCleanup(model.packageCleanup);
            this.excludeAppPackagesFromCleanup(model.excludeAppPackagesFromCleanup);
            this.rebootAfterUse(model.rebootAfterUse);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getPackageCleanup() {
            return this.packageCleanup;
        }

        public final void setPackageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
        }

        @Override
        public final Builder packageCleanup(Boolean packageCleanup) {
            this.packageCleanup = packageCleanup;
            return this;
        }

        public final Collection<String> getExcludeAppPackagesFromCleanup() {
            if (this.excludeAppPackagesFromCleanup instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludeAppPackagesFromCleanup;
        }

        public final void setExcludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
        }

        @Override
        public final Builder excludeAppPackagesFromCleanup(Collection<String> excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup = PackageIdsCopier.copy(excludeAppPackagesFromCleanup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeAppPackagesFromCleanup(String ... excludeAppPackagesFromCleanup) {
            this.excludeAppPackagesFromCleanup(Arrays.asList(excludeAppPackagesFromCleanup));
            return this;
        }

        public final Boolean getRebootAfterUse() {
            return this.rebootAfterUse;
        }

        public final void setRebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
        }

        @Override
        public final Builder rebootAfterUse(Boolean rebootAfterUse) {
            this.rebootAfterUse = rebootAfterUse;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceProfileRequest build() {
            return new CreateInstanceProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeviceFarmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInstanceProfileRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder packageCleanup(Boolean var1);

        public Builder excludeAppPackagesFromCleanup(Collection<String> var1);

        public Builder excludeAppPackagesFromCleanup(String ... var1);

        public Builder rebootAfterUse(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

