/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devicefarm.model.NetworkProfileType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(NetworkProfile.getter(NetworkProfile::arn)).setter(NetworkProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(NetworkProfile.getter(NetworkProfile::name)).setter(NetworkProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(NetworkProfile.getter(NetworkProfile::description)).setter(NetworkProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(NetworkProfile.getter(NetworkProfile::typeAsString)).setter(NetworkProfile.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Long> UPLINK_BANDWIDTH_BITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("uplinkBandwidthBits").getter(NetworkProfile.getter(NetworkProfile::uplinkBandwidthBits)).setter(NetworkProfile.setter(Builder::uplinkBandwidthBits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkBandwidthBits").build()}).build();
    private static final SdkField<Long> DOWNLINK_BANDWIDTH_BITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("downlinkBandwidthBits").getter(NetworkProfile.getter(NetworkProfile::downlinkBandwidthBits)).setter(NetworkProfile.setter(Builder::downlinkBandwidthBits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkBandwidthBits").build()}).build();
    private static final SdkField<Long> UPLINK_DELAY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("uplinkDelayMs").getter(NetworkProfile.getter(NetworkProfile::uplinkDelayMs)).setter(NetworkProfile.setter(Builder::uplinkDelayMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkDelayMs").build()}).build();
    private static final SdkField<Long> DOWNLINK_DELAY_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("downlinkDelayMs").getter(NetworkProfile.getter(NetworkProfile::downlinkDelayMs)).setter(NetworkProfile.setter(Builder::downlinkDelayMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkDelayMs").build()}).build();
    private static final SdkField<Long> UPLINK_JITTER_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("uplinkJitterMs").getter(NetworkProfile.getter(NetworkProfile::uplinkJitterMs)).setter(NetworkProfile.setter(Builder::uplinkJitterMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkJitterMs").build()}).build();
    private static final SdkField<Long> DOWNLINK_JITTER_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("downlinkJitterMs").getter(NetworkProfile.getter(NetworkProfile::downlinkJitterMs)).setter(NetworkProfile.setter(Builder::downlinkJitterMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkJitterMs").build()}).build();
    private static final SdkField<Integer> UPLINK_LOSS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("uplinkLossPercent").getter(NetworkProfile.getter(NetworkProfile::uplinkLossPercent)).setter(NetworkProfile.setter(Builder::uplinkLossPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkLossPercent").build()}).build();
    private static final SdkField<Integer> DOWNLINK_LOSS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("downlinkLossPercent").getter(NetworkProfile.getter(NetworkProfile::downlinkLossPercent)).setter(NetworkProfile.setter(Builder::downlinkLossPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downlinkLossPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, TYPE_FIELD, UPLINK_BANDWIDTH_BITS_FIELD, DOWNLINK_BANDWIDTH_BITS_FIELD, UPLINK_DELAY_MS_FIELD, DOWNLINK_DELAY_MS_FIELD, UPLINK_JITTER_MS_FIELD, DOWNLINK_JITTER_MS_FIELD, UPLINK_LOSS_PERCENT_FIELD, DOWNLINK_LOSS_PERCENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NetworkProfile.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String description;
    private final String type;
    private final Long uplinkBandwidthBits;
    private final Long downlinkBandwidthBits;
    private final Long uplinkDelayMs;
    private final Long downlinkDelayMs;
    private final Long uplinkJitterMs;
    private final Long downlinkJitterMs;
    private final Integer uplinkLossPercent;
    private final Integer downlinkLossPercent;

    private NetworkProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.type = builder.type;
        this.uplinkBandwidthBits = builder.uplinkBandwidthBits;
        this.downlinkBandwidthBits = builder.downlinkBandwidthBits;
        this.uplinkDelayMs = builder.uplinkDelayMs;
        this.downlinkDelayMs = builder.downlinkDelayMs;
        this.uplinkJitterMs = builder.uplinkJitterMs;
        this.downlinkJitterMs = builder.downlinkJitterMs;
        this.uplinkLossPercent = builder.uplinkLossPercent;
        this.downlinkLossPercent = builder.downlinkLossPercent;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final NetworkProfileType type() {
        return NetworkProfileType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Long uplinkBandwidthBits() {
        return this.uplinkBandwidthBits;
    }

    public final Long downlinkBandwidthBits() {
        return this.downlinkBandwidthBits;
    }

    public final Long uplinkDelayMs() {
        return this.uplinkDelayMs;
    }

    public final Long downlinkDelayMs() {
        return this.downlinkDelayMs;
    }

    public final Long uplinkJitterMs() {
        return this.uplinkJitterMs;
    }

    public final Long downlinkJitterMs() {
        return this.downlinkJitterMs;
    }

    public final Integer uplinkLossPercent() {
        return this.uplinkLossPercent;
    }

    public final Integer downlinkLossPercent() {
        return this.downlinkLossPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkBandwidthBits());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkDelayMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkJitterMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkLossPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.downlinkLossPercent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkProfile)) {
            return false;
        }
        NetworkProfile other = (NetworkProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.uplinkBandwidthBits(), other.uplinkBandwidthBits()) && Objects.equals(this.downlinkBandwidthBits(), other.downlinkBandwidthBits()) && Objects.equals(this.uplinkDelayMs(), other.uplinkDelayMs()) && Objects.equals(this.downlinkDelayMs(), other.downlinkDelayMs()) && Objects.equals(this.uplinkJitterMs(), other.uplinkJitterMs()) && Objects.equals(this.downlinkJitterMs(), other.downlinkJitterMs()) && Objects.equals(this.uplinkLossPercent(), other.uplinkLossPercent()) && Objects.equals(this.downlinkLossPercent(), other.downlinkLossPercent());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkProfile").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Type", (Object)this.typeAsString()).add("UplinkBandwidthBits", (Object)this.uplinkBandwidthBits()).add("DownlinkBandwidthBits", (Object)this.downlinkBandwidthBits()).add("UplinkDelayMs", (Object)this.uplinkDelayMs()).add("DownlinkDelayMs", (Object)this.downlinkDelayMs()).add("UplinkJitterMs", (Object)this.uplinkJitterMs()).add("DownlinkJitterMs", (Object)this.downlinkJitterMs()).add("UplinkLossPercent", (Object)this.uplinkLossPercent()).add("DownlinkLossPercent", (Object)this.downlinkLossPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "uplinkBandwidthBits": {
                return Optional.ofNullable(clazz.cast(this.uplinkBandwidthBits()));
            }
            case "downlinkBandwidthBits": {
                return Optional.ofNullable(clazz.cast(this.downlinkBandwidthBits()));
            }
            case "uplinkDelayMs": {
                return Optional.ofNullable(clazz.cast(this.uplinkDelayMs()));
            }
            case "downlinkDelayMs": {
                return Optional.ofNullable(clazz.cast(this.downlinkDelayMs()));
            }
            case "uplinkJitterMs": {
                return Optional.ofNullable(clazz.cast(this.uplinkJitterMs()));
            }
            case "downlinkJitterMs": {
                return Optional.ofNullable(clazz.cast(this.downlinkJitterMs()));
            }
            case "uplinkLossPercent": {
                return Optional.ofNullable(clazz.cast(this.uplinkLossPercent()));
            }
            case "downlinkLossPercent": {
                return Optional.ofNullable(clazz.cast(this.downlinkLossPercent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("uplinkBandwidthBits", UPLINK_BANDWIDTH_BITS_FIELD);
        map.put("downlinkBandwidthBits", DOWNLINK_BANDWIDTH_BITS_FIELD);
        map.put("uplinkDelayMs", UPLINK_DELAY_MS_FIELD);
        map.put("downlinkDelayMs", DOWNLINK_DELAY_MS_FIELD);
        map.put("uplinkJitterMs", UPLINK_JITTER_MS_FIELD);
        map.put("downlinkJitterMs", DOWNLINK_JITTER_MS_FIELD);
        map.put("uplinkLossPercent", UPLINK_LOSS_PERCENT_FIELD);
        map.put("downlinkLossPercent", DOWNLINK_LOSS_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NetworkProfile, T> g) {
        return obj -> g.apply((NetworkProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String description;
        private String type;
        private Long uplinkBandwidthBits;
        private Long downlinkBandwidthBits;
        private Long uplinkDelayMs;
        private Long downlinkDelayMs;
        private Long uplinkJitterMs;
        private Long downlinkJitterMs;
        private Integer uplinkLossPercent;
        private Integer downlinkLossPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkProfile model) {
            this.arn(model.arn);
            this.name(model.name);
            this.description(model.description);
            this.type(model.type);
            this.uplinkBandwidthBits(model.uplinkBandwidthBits);
            this.downlinkBandwidthBits(model.downlinkBandwidthBits);
            this.uplinkDelayMs(model.uplinkDelayMs);
            this.downlinkDelayMs(model.downlinkDelayMs);
            this.uplinkJitterMs(model.uplinkJitterMs);
            this.downlinkJitterMs(model.downlinkJitterMs);
            this.uplinkLossPercent(model.uplinkLossPercent);
            this.downlinkLossPercent(model.downlinkLossPercent);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(NetworkProfileType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Long getUplinkBandwidthBits() {
            return this.uplinkBandwidthBits;
        }

        public final void setUplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
        }

        @Override
        public final Builder uplinkBandwidthBits(Long uplinkBandwidthBits) {
            this.uplinkBandwidthBits = uplinkBandwidthBits;
            return this;
        }

        public final Long getDownlinkBandwidthBits() {
            return this.downlinkBandwidthBits;
        }

        public final void setDownlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
        }

        @Override
        public final Builder downlinkBandwidthBits(Long downlinkBandwidthBits) {
            this.downlinkBandwidthBits = downlinkBandwidthBits;
            return this;
        }

        public final Long getUplinkDelayMs() {
            return this.uplinkDelayMs;
        }

        public final void setUplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
        }

        @Override
        public final Builder uplinkDelayMs(Long uplinkDelayMs) {
            this.uplinkDelayMs = uplinkDelayMs;
            return this;
        }

        public final Long getDownlinkDelayMs() {
            return this.downlinkDelayMs;
        }

        public final void setDownlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
        }

        @Override
        public final Builder downlinkDelayMs(Long downlinkDelayMs) {
            this.downlinkDelayMs = downlinkDelayMs;
            return this;
        }

        public final Long getUplinkJitterMs() {
            return this.uplinkJitterMs;
        }

        public final void setUplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
        }

        @Override
        public final Builder uplinkJitterMs(Long uplinkJitterMs) {
            this.uplinkJitterMs = uplinkJitterMs;
            return this;
        }

        public final Long getDownlinkJitterMs() {
            return this.downlinkJitterMs;
        }

        public final void setDownlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
        }

        @Override
        public final Builder downlinkJitterMs(Long downlinkJitterMs) {
            this.downlinkJitterMs = downlinkJitterMs;
            return this;
        }

        public final Integer getUplinkLossPercent() {
            return this.uplinkLossPercent;
        }

        public final void setUplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
        }

        @Override
        public final Builder uplinkLossPercent(Integer uplinkLossPercent) {
            this.uplinkLossPercent = uplinkLossPercent;
            return this;
        }

        public final Integer getDownlinkLossPercent() {
            return this.downlinkLossPercent;
        }

        public final void setDownlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
        }

        @Override
        public final Builder downlinkLossPercent(Integer downlinkLossPercent) {
            this.downlinkLossPercent = downlinkLossPercent;
            return this;
        }

        public NetworkProfile build() {
            return new NetworkProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkProfile> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder type(String var1);

        public Builder type(NetworkProfileType var1);

        public Builder uplinkBandwidthBits(Long var1);

        public Builder downlinkBandwidthBits(Long var1);

        public Builder uplinkDelayMs(Long var1);

        public Builder downlinkDelayMs(Long var1);

        public Builder uplinkJitterMs(Long var1);

        public Builder downlinkJitterMs(Long var1);

        public Builder uplinkLossPercent(Integer var1);

        public Builder downlinkLossPercent(Integer var1);
    }
}

