/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about the detection source that generates proactive anomalies. The anomaly is detected using analysis of the
 * metric data&#x2028; over a period of time
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalySourceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalySourceMetadata.Builder, AnomalySourceMetadata> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(AnomalySourceMetadata::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SOURCE_RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceName").getter(getter(AnomalySourceMetadata::sourceResourceName))
            .setter(setter(Builder::sourceResourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceName").build())
            .build();

    private static final SdkField<String> SOURCE_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceResourceType").getter(getter(AnomalySourceMetadata::sourceResourceType))
            .setter(setter(Builder::sourceResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceResourceType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD,
            SOURCE_RESOURCE_NAME_FIELD, SOURCE_RESOURCE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String source;

    private final String sourceResourceName;

    private final String sourceResourceType;

    private AnomalySourceMetadata(BuilderImpl builder) {
        this.source = builder.source;
        this.sourceResourceName = builder.sourceResourceName;
        this.sourceResourceType = builder.sourceResourceType;
    }

    /**
     * <p>
     * The source of the anomaly.
     * </p>
     * 
     * @return The source of the anomaly.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The name of the anomaly's resource.
     * </p>
     * 
     * @return The name of the anomaly's resource.
     */
    public final String sourceResourceName() {
        return sourceResourceName;
    }

    /**
     * <p>
     * The anomaly's resource type.
     * </p>
     * 
     * @return The anomaly's resource type.
     */
    public final String sourceResourceType() {
        return sourceResourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceResourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalySourceMetadata)) {
            return false;
        }
        AnomalySourceMetadata other = (AnomalySourceMetadata) obj;
        return Objects.equals(source(), other.source()) && Objects.equals(sourceResourceName(), other.sourceResourceName())
                && Objects.equals(sourceResourceType(), other.sourceResourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalySourceMetadata").add("Source", source()).add("SourceResourceName", sourceResourceName())
                .add("SourceResourceType", sourceResourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceResourceName":
            return Optional.ofNullable(clazz.cast(sourceResourceName()));
        case "SourceResourceType":
            return Optional.ofNullable(clazz.cast(sourceResourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalySourceMetadata, T> g) {
        return obj -> g.apply((AnomalySourceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalySourceMetadata> {
        /**
         * <p>
         * The source of the anomaly.
         * </p>
         * 
         * @param source
         *        The source of the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The name of the anomaly's resource.
         * </p>
         * 
         * @param sourceResourceName
         *        The name of the anomaly's resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceName(String sourceResourceName);

        /**
         * <p>
         * The anomaly's resource type.
         * </p>
         * 
         * @param sourceResourceType
         *        The anomaly's resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceResourceType(String sourceResourceType);
    }

    static final class BuilderImpl implements Builder {
        private String source;

        private String sourceResourceName;

        private String sourceResourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalySourceMetadata model) {
            source(model.source);
            sourceResourceName(model.sourceResourceName);
            sourceResourceType(model.sourceResourceType);
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourceResourceName() {
            return sourceResourceName;
        }

        public final void setSourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
        }

        @Override
        public final Builder sourceResourceName(String sourceResourceName) {
            this.sourceResourceName = sourceResourceName;
            return this;
        }

        public final String getSourceResourceType() {
            return sourceResourceType;
        }

        public final void setSourceResourceType(String sourceResourceType) {
            this.sourceResourceType = sourceResourceType;
        }

        @Override
        public final Builder sourceResourceType(String sourceResourceType) {
            this.sourceResourceType = sourceResourceType;
            return this;
        }

        @Override
        public AnomalySourceMetadata build() {
            return new AnomalySourceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
