/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A cluster of similar anomalous log events found within a log group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogAnomalyShowcase implements SdkPojo, Serializable,
        ToCopyableBuilder<LogAnomalyShowcase.Builder, LogAnomalyShowcase> {
    private static final SdkField<List<LogAnomalyClass>> LOG_ANOMALY_CLASSES_FIELD = SdkField
            .<List<LogAnomalyClass>> builder(MarshallingType.LIST)
            .memberName("LogAnomalyClasses")
            .getter(getter(LogAnomalyShowcase::logAnomalyClasses))
            .setter(setter(Builder::logAnomalyClasses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogAnomalyClasses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LogAnomalyClass> builder(MarshallingType.SDK_POJO)
                                            .constructor(LogAnomalyClass::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_ANOMALY_CLASSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<LogAnomalyClass> logAnomalyClasses;

    private LogAnomalyShowcase(BuilderImpl builder) {
        this.logAnomalyClasses = builder.logAnomalyClasses;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogAnomalyClasses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogAnomalyClasses() {
        return logAnomalyClasses != null && !(logAnomalyClasses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of anomalous log events that may be related.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogAnomalyClasses} method.
     * </p>
     * 
     * @return A list of anomalous log events that may be related.
     */
    public final List<LogAnomalyClass> logAnomalyClasses() {
        return logAnomalyClasses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogAnomalyClasses() ? logAnomalyClasses() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogAnomalyShowcase)) {
            return false;
        }
        LogAnomalyShowcase other = (LogAnomalyShowcase) obj;
        return hasLogAnomalyClasses() == other.hasLogAnomalyClasses()
                && Objects.equals(logAnomalyClasses(), other.logAnomalyClasses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogAnomalyShowcase")
                .add("LogAnomalyClasses", hasLogAnomalyClasses() ? logAnomalyClasses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogAnomalyClasses":
            return Optional.ofNullable(clazz.cast(logAnomalyClasses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogAnomalyShowcase, T> g) {
        return obj -> g.apply((LogAnomalyShowcase) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogAnomalyShowcase> {
        /**
         * <p>
         * A list of anomalous log events that may be related.
         * </p>
         * 
         * @param logAnomalyClasses
         *        A list of anomalous log events that may be related.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logAnomalyClasses(Collection<LogAnomalyClass> logAnomalyClasses);

        /**
         * <p>
         * A list of anomalous log events that may be related.
         * </p>
         * 
         * @param logAnomalyClasses
         *        A list of anomalous log events that may be related.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logAnomalyClasses(LogAnomalyClass... logAnomalyClasses);

        /**
         * <p>
         * A list of anomalous log events that may be related.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass.Builder#build()} is called
         * immediately and its result is passed to {@link #logAnomalyClasses(List<LogAnomalyClass>)}.
         * 
         * @param logAnomalyClasses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.LogAnomalyClass.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logAnomalyClasses(java.util.Collection<LogAnomalyClass>)
         */
        Builder logAnomalyClasses(Consumer<LogAnomalyClass.Builder>... logAnomalyClasses);
    }

    static final class BuilderImpl implements Builder {
        private List<LogAnomalyClass> logAnomalyClasses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogAnomalyShowcase model) {
            logAnomalyClasses(model.logAnomalyClasses);
        }

        public final List<LogAnomalyClass.Builder> getLogAnomalyClasses() {
            List<LogAnomalyClass.Builder> result = LogAnomalyClassesCopier.copyToBuilder(this.logAnomalyClasses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLogAnomalyClasses(Collection<LogAnomalyClass.BuilderImpl> logAnomalyClasses) {
            this.logAnomalyClasses = LogAnomalyClassesCopier.copyFromBuilder(logAnomalyClasses);
        }

        @Override
        public final Builder logAnomalyClasses(Collection<LogAnomalyClass> logAnomalyClasses) {
            this.logAnomalyClasses = LogAnomalyClassesCopier.copy(logAnomalyClasses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyClasses(LogAnomalyClass... logAnomalyClasses) {
            logAnomalyClasses(Arrays.asList(logAnomalyClasses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logAnomalyClasses(Consumer<LogAnomalyClass.Builder>... logAnomalyClasses) {
            logAnomalyClasses(Stream.of(logAnomalyClasses).map(c -> LogAnomalyClass.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public LogAnomalyShowcase build() {
            return new LogAnomalyShowcase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
