/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a reactive insight. This object is returned by <code>DescribeInsight.</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReactiveInsightSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ReactiveInsightSummary.Builder, ReactiveInsightSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ReactiveInsightSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ReactiveInsightSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ReactiveInsightSummary::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ReactiveInsightSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<InsightTimeRange> INSIGHT_TIME_RANGE_FIELD = SdkField
            .<InsightTimeRange> builder(MarshallingType.SDK_POJO).memberName("InsightTimeRange")
            .getter(getter(ReactiveInsightSummary::insightTimeRange)).setter(setter(Builder::insightTimeRange))
            .constructor(InsightTimeRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightTimeRange").build()).build();

    private static final SdkField<ResourceCollection> RESOURCE_COLLECTION_FIELD = SdkField
            .<ResourceCollection> builder(MarshallingType.SDK_POJO).memberName("ResourceCollection")
            .getter(getter(ReactiveInsightSummary::resourceCollection)).setter(setter(Builder::resourceCollection))
            .constructor(ResourceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCollection").build())
            .build();

    private static final SdkField<ServiceCollection> SERVICE_COLLECTION_FIELD = SdkField
            .<ServiceCollection> builder(MarshallingType.SDK_POJO).memberName("ServiceCollection")
            .getter(getter(ReactiveInsightSummary::serviceCollection)).setter(setter(Builder::serviceCollection))
            .constructor(ServiceCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCollection").build()).build();

    private static final SdkField<List<String>> ASSOCIATED_RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AssociatedResourceArns")
            .getter(getter(ReactiveInsightSummary::associatedResourceArns))
            .setter(setter(Builder::associatedResourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedResourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            SEVERITY_FIELD, STATUS_FIELD, INSIGHT_TIME_RANGE_FIELD, RESOURCE_COLLECTION_FIELD, SERVICE_COLLECTION_FIELD,
            ASSOCIATED_RESOURCE_ARNS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String severity;

    private final String status;

    private final InsightTimeRange insightTimeRange;

    private final ResourceCollection resourceCollection;

    private final ServiceCollection serviceCollection;

    private final List<String> associatedResourceArns;

    private ReactiveInsightSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.severity = builder.severity;
        this.status = builder.status;
        this.insightTimeRange = builder.insightTimeRange;
        this.resourceCollection = builder.resourceCollection;
        this.serviceCollection = builder.serviceCollection;
        this.associatedResourceArns = builder.associatedResourceArns;
    }

    /**
     * <p>
     * The ID of a reactive summary.
     * </p>
     * 
     * @return The ID of a reactive summary.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of a reactive insight.
     * </p>
     * 
     * @return The name of a reactive insight.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The severity of the insight. For more information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the insight. For more information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * @see InsightSeverity
     */
    public final InsightSeverity severity() {
        return InsightSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the insight. For more information, see <a href=
     * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link InsightSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the insight. For more information, see <a href=
     *         "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
     *         >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
     * @see InsightSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The status of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a reactive insight.
     * @see InsightStatus
     */
    public final InsightStatus status() {
        return InsightStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a reactive insight.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InsightStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a reactive insight.
     * @see InsightStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the InsightTimeRange property for this object.
     * 
     * @return The value of the InsightTimeRange property for this object.
     */
    public final InsightTimeRange insightTimeRange() {
        return insightTimeRange;
    }

    /**
     * Returns the value of the ResourceCollection property for this object.
     * 
     * @return The value of the ResourceCollection property for this object.
     */
    public final ResourceCollection resourceCollection() {
        return resourceCollection;
    }

    /**
     * <p>
     * A collection of the names of Amazon Web Services services.
     * </p>
     * 
     * @return A collection of the names of Amazon Web Services services.
     */
    public final ServiceCollection serviceCollection() {
        return serviceCollection;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedResourceArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssociatedResourceArns() {
        return associatedResourceArns != null && !(associatedResourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedResourceArns} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
     */
    public final List<String> associatedResourceArns() {
        return associatedResourceArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(insightTimeRange());
        hashCode = 31 * hashCode + Objects.hashCode(resourceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCollection());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedResourceArns() ? associatedResourceArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReactiveInsightSummary)) {
            return false;
        }
        ReactiveInsightSummary other = (ReactiveInsightSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(insightTimeRange(), other.insightTimeRange())
                && Objects.equals(resourceCollection(), other.resourceCollection())
                && Objects.equals(serviceCollection(), other.serviceCollection())
                && hasAssociatedResourceArns() == other.hasAssociatedResourceArns()
                && Objects.equals(associatedResourceArns(), other.associatedResourceArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReactiveInsightSummary").add("Id", id()).add("Name", name()).add("Severity", severityAsString())
                .add("Status", statusAsString()).add("InsightTimeRange", insightTimeRange())
                .add("ResourceCollection", resourceCollection()).add("ServiceCollection", serviceCollection())
                .add("AssociatedResourceArns", hasAssociatedResourceArns() ? associatedResourceArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "InsightTimeRange":
            return Optional.ofNullable(clazz.cast(insightTimeRange()));
        case "ResourceCollection":
            return Optional.ofNullable(clazz.cast(resourceCollection()));
        case "ServiceCollection":
            return Optional.ofNullable(clazz.cast(serviceCollection()));
        case "AssociatedResourceArns":
            return Optional.ofNullable(clazz.cast(associatedResourceArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReactiveInsightSummary, T> g) {
        return obj -> g.apply((ReactiveInsightSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReactiveInsightSummary> {
        /**
         * <p>
         * The ID of a reactive summary.
         * </p>
         * 
         * @param id
         *        The ID of a reactive summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of a reactive insight.
         * </p>
         * 
         * @param name
         *        The name of a reactive insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The severity of the insight. For more information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * </p>
         * 
         * @param severity
         *        The severity of the insight. For more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the insight. For more information, see <a href=
         * "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         * >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * </p>
         * 
         * @param severity
         *        The severity of the insight. For more information, see <a href=
         *        "https://docs.aws.amazon.com/devops-guru/latest/userguide/working-with-insights.html#understanding-insights-severities"
         *        >Understanding insight severities</a> in the <i>Amazon DevOps Guru User Guide</i>.
         * @see InsightSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightSeverity
         */
        Builder severity(InsightSeverity severity);

        /**
         * <p>
         * The status of a reactive insight.
         * </p>
         * 
         * @param status
         *        The status of a reactive insight.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a reactive insight.
         * </p>
         * 
         * @param status
         *        The status of a reactive insight.
         * @see InsightStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InsightStatus
         */
        Builder status(InsightStatus status);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * @param insightTimeRange
         *        The new value for the InsightTimeRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insightTimeRange(InsightTimeRange insightTimeRange);

        /**
         * Sets the value of the InsightTimeRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InsightTimeRange.Builder} avoiding the
         * need to create one manually via {@link InsightTimeRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsightTimeRange.Builder#build()} is called immediately and its
         * result is passed to {@link #insightTimeRange(InsightTimeRange)}.
         * 
         * @param insightTimeRange
         *        a consumer that will call methods on {@link InsightTimeRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insightTimeRange(InsightTimeRange)
         */
        default Builder insightTimeRange(Consumer<InsightTimeRange.Builder> insightTimeRange) {
            return insightTimeRange(InsightTimeRange.builder().applyMutation(insightTimeRange).build());
        }

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * @param resourceCollection
         *        The new value for the ResourceCollection property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceCollection(ResourceCollection resourceCollection);

        /**
         * Sets the value of the ResourceCollection property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceCollection.Builder} avoiding the
         * need to create one manually via {@link ResourceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceCollection(ResourceCollection)}.
         * 
         * @param resourceCollection
         *        a consumer that will call methods on {@link ResourceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceCollection(ResourceCollection)
         */
        default Builder resourceCollection(Consumer<ResourceCollection.Builder> resourceCollection) {
            return resourceCollection(ResourceCollection.builder().applyMutation(resourceCollection).build());
        }

        /**
         * <p>
         * A collection of the names of Amazon Web Services services.
         * </p>
         * 
         * @param serviceCollection
         *        A collection of the names of Amazon Web Services services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCollection(ServiceCollection serviceCollection);

        /**
         * <p>
         * A collection of the names of Amazon Web Services services.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceCollection.Builder} avoiding the
         * need to create one manually via {@link ServiceCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCollection.Builder#build()} is called immediately and its
         * result is passed to {@link #serviceCollection(ServiceCollection)}.
         * 
         * @param serviceCollection
         *        a consumer that will call methods on {@link ServiceCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCollection(ServiceCollection)
         */
        default Builder serviceCollection(Consumer<ServiceCollection.Builder> serviceCollection) {
            return serviceCollection(ServiceCollection.builder().applyMutation(serviceCollection).build());
        }

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
         * </p>
         * 
         * @param associatedResourceArns
         *        The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArns(Collection<String> associatedResourceArns);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
         * </p>
         * 
         * @param associatedResourceArns
         *        The Amazon Resource Names (ARNs) of the Amazon Web Services resources that generated this insight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedResourceArns(String... associatedResourceArns);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String severity;

        private String status;

        private InsightTimeRange insightTimeRange;

        private ResourceCollection resourceCollection;

        private ServiceCollection serviceCollection;

        private List<String> associatedResourceArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReactiveInsightSummary model) {
            id(model.id);
            name(model.name);
            severity(model.severity);
            status(model.status);
            insightTimeRange(model.insightTimeRange);
            resourceCollection(model.resourceCollection);
            serviceCollection(model.serviceCollection);
            associatedResourceArns(model.associatedResourceArns);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(InsightSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InsightStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final InsightTimeRange.Builder getInsightTimeRange() {
            return insightTimeRange != null ? insightTimeRange.toBuilder() : null;
        }

        public final void setInsightTimeRange(InsightTimeRange.BuilderImpl insightTimeRange) {
            this.insightTimeRange = insightTimeRange != null ? insightTimeRange.build() : null;
        }

        @Override
        public final Builder insightTimeRange(InsightTimeRange insightTimeRange) {
            this.insightTimeRange = insightTimeRange;
            return this;
        }

        public final ResourceCollection.Builder getResourceCollection() {
            return resourceCollection != null ? resourceCollection.toBuilder() : null;
        }

        public final void setResourceCollection(ResourceCollection.BuilderImpl resourceCollection) {
            this.resourceCollection = resourceCollection != null ? resourceCollection.build() : null;
        }

        @Override
        public final Builder resourceCollection(ResourceCollection resourceCollection) {
            this.resourceCollection = resourceCollection;
            return this;
        }

        public final ServiceCollection.Builder getServiceCollection() {
            return serviceCollection != null ? serviceCollection.toBuilder() : null;
        }

        public final void setServiceCollection(ServiceCollection.BuilderImpl serviceCollection) {
            this.serviceCollection = serviceCollection != null ? serviceCollection.build() : null;
        }

        @Override
        public final Builder serviceCollection(ServiceCollection serviceCollection) {
            this.serviceCollection = serviceCollection;
            return this;
        }

        public final Collection<String> getAssociatedResourceArns() {
            if (associatedResourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedResourceArns;
        }

        public final void setAssociatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = AssociatedResourceArnsCopier.copy(associatedResourceArns);
        }

        @Override
        public final Builder associatedResourceArns(Collection<String> associatedResourceArns) {
            this.associatedResourceArns = AssociatedResourceArnsCopier.copy(associatedResourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedResourceArns(String... associatedResourceArns) {
            associatedResourceArns(Arrays.asList(associatedResourceArns));
            return this;
        }

        @Override
        public ReactiveInsightSummary build() {
            return new ReactiveInsightSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
