/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of Amazon Web Services resources supported by DevOps Guru. The two types of Amazon Web Services resource
 * collections supported are Amazon Web Services CloudFormation stacks and Amazon Web Services resources that contain
 * the same Amazon Web Services tag. DevOps Guru can be configured to analyze the Amazon Web Services resources that are
 * defined in the stacks or that are tagged using the same tag <i>key</i>. You can specify up to 500 Amazon Web Services
 * CloudFormation stacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceCollection implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceCollection.Builder, ResourceCollection> {
    private static final SdkField<CloudFormationCollection> CLOUD_FORMATION_FIELD = SdkField
            .<CloudFormationCollection> builder(MarshallingType.SDK_POJO).memberName("CloudFormation")
            .getter(getter(ResourceCollection::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(CloudFormationCollection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormation").build()).build();

    private static final SdkField<List<TagCollection>> TAGS_FIELD = SdkField
            .<List<TagCollection>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ResourceCollection::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TagCollection> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagCollection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD,
            TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudFormationCollection cloudFormation;

    private final List<TagCollection> tags;

    private ResourceCollection(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services
     * resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     * </p>
     * 
     * @return An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services
     *         resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks.
     */
    public final CloudFormationCollection cloudFormation() {
        return cloudFormation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services tags that are used by resources in the resource collection.
     * </p>
     * <p>
     * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services support
     * tagging, so you can assign the same tag to resources from different services to indicate that the resources are
     * related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you assign to an
     * Lambda function. For more information about using tags, see the <a
     * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html">Tagging
     * best practices</a> whitepaper.
     * </p>
     * <p>
     * Each Amazon Web Services tag has two parts.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
     * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
     * </p>
     * </li>
     * <li>
     * <p>
     * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>, <code>Production</code>,
     * or a team name). Omitting the tag <i>value</i> is the same as using an empty string. Like tag <i>keys</i>, tag
     * <i>values</i> are case-sensitive.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Together these are known as <i>key</i>-<i>value</i> pairs.
     * </p>
     * <important>
     * <p>
     * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
     * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code> or
     * <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the <i>key</i>
     * can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works
     * with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and
     * these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     * <code>Devops-Guru-production-application/RDS</code> or <code>Devops-Guru-production-application/containers</code>
     * .
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The Amazon Web Services tags that are used by resources in the resource collection.</p>
     *         <p>
     *         Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
     *         support tagging, so you can assign the same tag to resources from different services to indicate that the
     *         resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that
     *         you assign to an Lambda function. For more information about using tags, see the <a href=
     *         "https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
     *         >Tagging best practices</a> whitepaper.
     *         </p>
     *         <p>
     *         Each Amazon Web Services tag has two parts.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>,
     *         or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
     *         <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
     *         string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Together these are known as <i>key</i>-<i>value</i> pairs.
     *         </p>
     *         <important>
     *         <p>
     *         The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with
     *         the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
     *         <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
     *         create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
     *         create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
     *         <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
     *         different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
     *         <code>Devops-Guru-production-application/RDS</code> or
     *         <code>Devops-Guru-production-application/containers</code>.
     *         </p>
     */
    public final List<TagCollection> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceCollection)) {
            return false;
        }
        ResourceCollection other = (ResourceCollection) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceCollection").add("CloudFormation", cloudFormation())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceCollection, T> g) {
        return obj -> g.apply((ResourceCollection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceCollection> {
        /**
         * <p>
         * An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services
         * resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * 
         * @param cloudFormation
         *        An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web
         *        Services resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services
         *        CloudFormation stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationCollection cloudFormation);

        /**
         * <p>
         * An array of the names of Amazon Web Services CloudFormation stacks. The stacks define Amazon Web Services
         * resources that DevOps Guru analyzes. You can specify up to 500 Amazon Web Services CloudFormation stacks.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudFormationCollection.Builder}
         * avoiding the need to create one manually via {@link CloudFormationCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFormationCollection.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFormation(CloudFormationCollection)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link CloudFormationCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(CloudFormationCollection)
         */
        default Builder cloudFormation(Consumer<CloudFormationCollection.Builder> cloudFormation) {
            return cloudFormation(CloudFormationCollection.builder().applyMutation(cloudFormation).build());
        }

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
         * >Tagging best practices</a> whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param tags
         *        The Amazon Web Services tags that are used by resources in the resource collection.</p>
         *        <p>
         *        Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services
         *        services support tagging, so you can assign the same tag to resources from different services to
         *        indicate that the resources are related. For example, you can assign the same tag to an Amazon
         *        DynamoDB table resource that you assign to an Lambda function. For more information about using tags,
         *        see the <a href=
         *        "https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
         *        >Tagging best practices</a> whitepaper.
         *        </p>
         *        <p>
         *        Each Amazon Web Services tag has two parts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>
         *        , or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         *        <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
         *        string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Together these are known as <i>key</i>-<i>value</i> pairs.
         *        </p>
         *        <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<TagCollection> tags);

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
         * >Tagging best practices</a> whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important>
         * 
         * @param tags
         *        The Amazon Web Services tags that are used by resources in the resource collection.</p>
         *        <p>
         *        Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services
         *        services support tagging, so you can assign the same tag to resources from different services to
         *        indicate that the resources are related. For example, you can assign the same tag to an Amazon
         *        DynamoDB table resource that you assign to an Lambda function. For more information about using tags,
         *        see the <a href=
         *        "https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
         *        >Tagging best practices</a> whitepaper.
         *        </p>
         *        <p>
         *        Each Amazon Web Services tag has two parts.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>
         *        , or <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         *        <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty
         *        string. Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Together these are known as <i>key</i>-<i>value</i> pairs.
         *        </p>
         *        <important>
         *        <p>
         *        The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin
         *        with the prefix <code>Devops-guru-</code>. The tag <i>key</i> might be
         *        <code>DevOps-Guru-deployment-application</code> or <code>devops-guru-rds-application</code>. When you
         *        create a <i>key</i>, the case of characters in the <i>key</i> can be whatever you choose. After you
         *        create a <i>key</i>, it is case-sensitive. For example, DevOps Guru works with a <i>key</i> named
         *        <code>devops-guru-rds</code> and a <i>key</i> named <code>DevOps-Guru-RDS</code>, and these act as two
         *        different <i>keys</i>. Possible <i>key</i>/<i>value</i> pairs in your application might be
         *        <code>Devops-Guru-production-application/RDS</code> or
         *        <code>Devops-Guru-production-application/containers</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(TagCollection... tags);

        /**
         * <p>
         * The Amazon Web Services tags that are used by resources in the resource collection.
         * </p>
         * <p>
         * Tags help you identify and organize your Amazon Web Services resources. Many Amazon Web Services services
         * support tagging, so you can assign the same tag to resources from different services to indicate that the
         * resources are related. For example, you can assign the same tag to an Amazon DynamoDB table resource that you
         * assign to an Lambda function. For more information about using tags, see the <a
         * href="https://docs.aws.amazon.com/whitepapers/latest/tagging-best-practices/tagging-best-practices.html"
         * >Tagging best practices</a> whitepaper.
         * </p>
         * <p>
         * Each Amazon Web Services tag has two parts.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A tag <i>key</i> (for example, <code>CostCenter</code>, <code>Environment</code>, <code>Project</code>, or
         * <code>Secret</code>). Tag <i>keys</i> are case-sensitive.
         * </p>
         * </li>
         * <li>
         * <p>
         * An optional field known as a tag <i>value</i> (for example, <code>111122223333</code>,
         * <code>Production</code>, or a team name). Omitting the tag <i>value</i> is the same as using an empty string.
         * Like tag <i>keys</i>, tag <i>values</i> are case-sensitive.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Together these are known as <i>key</i>-<i>value</i> pairs.
         * </p>
         * <important>
         * <p>
         * The string used for a <i>key</i> in a tag that you use to define your resource coverage must begin with the
         * prefix <code>Devops-guru-</code>. The tag <i>key</i> might be <code>DevOps-Guru-deployment-application</code>
         * or <code>devops-guru-rds-application</code>. When you create a <i>key</i>, the case of characters in the
         * <i>key</i> can be whatever you choose. After you create a <i>key</i>, it is case-sensitive. For example,
         * DevOps Guru works with a <i>key</i> named <code>devops-guru-rds</code> and a <i>key</i> named
         * <code>DevOps-Guru-RDS</code>, and these act as two different <i>keys</i>. Possible <i>key</i>/<i>value</i>
         * pairs in your application might be <code>Devops-Guru-production-application/RDS</code> or
         * <code>Devops-Guru-production-application/containers</code>.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.devopsguru.model.TagCollection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.devopsguru.model.TagCollection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.devopsguru.model.TagCollection.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<TagCollection>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.devopsguru.model.TagCollection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<TagCollection>)
         */
        Builder tags(Consumer<TagCollection.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationCollection cloudFormation;

        private List<TagCollection> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceCollection model) {
            cloudFormation(model.cloudFormation);
            tags(model.tags);
        }

        public final CloudFormationCollection.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationCollection.BuilderImpl cloudFormation) {
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
        }

        @Override
        public final Builder cloudFormation(CloudFormationCollection cloudFormation) {
            this.cloudFormation = cloudFormation;
            return this;
        }

        public final List<TagCollection.Builder> getTags() {
            List<TagCollection.Builder> result = TagCollectionsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<TagCollection.BuilderImpl> tags) {
            this.tags = TagCollectionsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<TagCollection> tags) {
            this.tags = TagCollectionsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(TagCollection... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<TagCollection.Builder>... tags) {
            tags(Stream.of(tags).map(c -> TagCollection.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ResourceCollection build() {
            return new ResourceCollection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
