/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CloudWatchMetricsStat {
    SUM("Sum"),
    AVERAGE("Average"),
    SAMPLE_COUNT("SampleCount"),
    MINIMUM("Minimum"),
    MAXIMUM("Maximum"),
    P99("p99"),
    P90("p90"),
    P50("p50"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CloudWatchMetricsStat> VALUE_MAP;
    private final String value;

    private CloudWatchMetricsStat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CloudWatchMetricsStat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CloudWatchMetricsStat> knownValues() {
        EnumSet<CloudWatchMetricsStat> knownValues = EnumSet.allOf(CloudWatchMetricsStat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CloudWatchMetricsStat.class, CloudWatchMetricsStat::toString);
    }
}

