/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.devopsguru.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.devopsguru.model.ServiceInsightHealth;
import software.amazon.awssdk.services.devopsguru.model.ServiceName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceHealth
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceHealth> {
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceHealth.getter(ServiceHealth::serviceNameAsString)).setter(ServiceHealth.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<ServiceInsightHealth> INSIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Insight").getter(ServiceHealth.getter(ServiceHealth::insight)).setter(ServiceHealth.setter(Builder::insight)).constructor(ServiceInsightHealth::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Insight").build()}).build();
    private static final SdkField<Long> ANALYZED_RESOURCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("AnalyzedResourceCount").getter(ServiceHealth.getter(ServiceHealth::analyzedResourceCount)).setter(ServiceHealth.setter(Builder::analyzedResourceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalyzedResourceCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAME_FIELD, INSIGHT_FIELD, ANALYZED_RESOURCE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceHealth.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceName;
    private final ServiceInsightHealth insight;
    private final Long analyzedResourceCount;

    private ServiceHealth(BuilderImpl builder) {
        this.serviceName = builder.serviceName;
        this.insight = builder.insight;
        this.analyzedResourceCount = builder.analyzedResourceCount;
    }

    public final ServiceName serviceName() {
        return ServiceName.fromValue(this.serviceName);
    }

    public final String serviceNameAsString() {
        return this.serviceName;
    }

    public final ServiceInsightHealth insight() {
        return this.insight;
    }

    public final Long analyzedResourceCount() {
        return this.analyzedResourceCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.insight());
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedResourceCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceHealth)) {
            return false;
        }
        ServiceHealth other = (ServiceHealth)obj;
        return Objects.equals(this.serviceNameAsString(), other.serviceNameAsString()) && Objects.equals(this.insight(), other.insight()) && Objects.equals(this.analyzedResourceCount(), other.analyzedResourceCount());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceHealth").add("ServiceName", (Object)this.serviceNameAsString()).add("Insight", (Object)this.insight()).add("AnalyzedResourceCount", (Object)this.analyzedResourceCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceNameAsString()));
            }
            case "Insight": {
                return Optional.ofNullable(clazz.cast(this.insight()));
            }
            case "AnalyzedResourceCount": {
                return Optional.ofNullable(clazz.cast(this.analyzedResourceCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceName", SERVICE_NAME_FIELD);
        map.put("Insight", INSIGHT_FIELD);
        map.put("AnalyzedResourceCount", ANALYZED_RESOURCE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceHealth, T> g) {
        return obj -> g.apply((ServiceHealth)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceName;
        private ServiceInsightHealth insight;
        private Long analyzedResourceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceHealth model) {
            this.serviceName(model.serviceName);
            this.insight(model.insight);
            this.analyzedResourceCount(model.analyzedResourceCount);
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public final Builder serviceName(ServiceName serviceName) {
            this.serviceName(serviceName == null ? null : serviceName.toString());
            return this;
        }

        public final ServiceInsightHealth.Builder getInsight() {
            return this.insight != null ? this.insight.toBuilder() : null;
        }

        public final void setInsight(ServiceInsightHealth.BuilderImpl insight) {
            this.insight = insight != null ? insight.build() : null;
        }

        @Override
        public final Builder insight(ServiceInsightHealth insight) {
            this.insight = insight;
            return this;
        }

        public final Long getAnalyzedResourceCount() {
            return this.analyzedResourceCount;
        }

        public final void setAnalyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
        }

        @Override
        public final Builder analyzedResourceCount(Long analyzedResourceCount) {
            this.analyzedResourceCount = analyzedResourceCount;
            return this;
        }

        public ServiceHealth build() {
            return new ServiceHealth(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceHealth> {
        public Builder serviceName(String var1);

        public Builder serviceName(ServiceName var1);

        public Builder insight(ServiceInsightHealth var1);

        default public Builder insight(Consumer<ServiceInsightHealth.Builder> insight) {
            return this.insight((ServiceInsightHealth)((ServiceInsightHealth.Builder)ServiceInsightHealth.builder().applyMutation(insight)).build());
        }

        public Builder analyzedResourceCount(Long var1);
    }
}

