/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.UpdateActivitiesCopier;
import software.amazon.awssdk.services.directory.model.UpdateInfoEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUpdateDirectoryResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeUpdateDirectoryResponse> {
    private static final SdkField<List<UpdateInfoEntry>> UPDATE_ACTIVITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UpdateActivities").getter(DescribeUpdateDirectoryResponse.getter(DescribeUpdateDirectoryResponse::updateActivities)).setter(DescribeUpdateDirectoryResponse.setter(Builder::updateActivities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateActivities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateInfoEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeUpdateDirectoryResponse.getter(DescribeUpdateDirectoryResponse::nextToken)).setter(DescribeUpdateDirectoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_ACTIVITIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<UpdateInfoEntry> updateActivities;
    private final String nextToken;

    private DescribeUpdateDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.updateActivities = builder.updateActivities;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasUpdateActivities() {
        return this.updateActivities != null && !(this.updateActivities instanceof SdkAutoConstructList);
    }

    public final List<UpdateInfoEntry> updateActivities() {
        return this.updateActivities;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateActivities() ? this.updateActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUpdateDirectoryResponse)) {
            return false;
        }
        DescribeUpdateDirectoryResponse other = (DescribeUpdateDirectoryResponse)((Object)obj);
        return this.hasUpdateActivities() == other.hasUpdateActivities() && Objects.equals(this.updateActivities(), other.updateActivities()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeUpdateDirectoryResponse").add("UpdateActivities", this.hasUpdateActivities() ? this.updateActivities() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpdateActivities": {
                return Optional.ofNullable(clazz.cast(this.updateActivities()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUpdateDirectoryResponse, T> g) {
        return obj -> g.apply((DescribeUpdateDirectoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<UpdateInfoEntry> updateActivities = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUpdateDirectoryResponse model) {
            super(model);
            this.updateActivities(model.updateActivities);
            this.nextToken(model.nextToken);
        }

        public final List<UpdateInfoEntry.Builder> getUpdateActivities() {
            List<UpdateInfoEntry.Builder> result = UpdateActivitiesCopier.copyToBuilder(this.updateActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUpdateActivities(Collection<UpdateInfoEntry.BuilderImpl> updateActivities) {
            this.updateActivities = UpdateActivitiesCopier.copyFromBuilder(updateActivities);
        }

        @Override
        public final Builder updateActivities(Collection<UpdateInfoEntry> updateActivities) {
            this.updateActivities = UpdateActivitiesCopier.copy(updateActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActivities(UpdateInfoEntry ... updateActivities) {
            this.updateActivities(Arrays.asList(updateActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateActivities(Consumer<UpdateInfoEntry.Builder> ... updateActivities) {
            this.updateActivities(Stream.of(updateActivities).map(c -> (UpdateInfoEntry)((UpdateInfoEntry.Builder)UpdateInfoEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeUpdateDirectoryResponse build() {
            return new DescribeUpdateDirectoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUpdateDirectoryResponse> {
        public Builder updateActivities(Collection<UpdateInfoEntry> var1);

        public Builder updateActivities(UpdateInfoEntry ... var1);

        public Builder updateActivities(Consumer<UpdateInfoEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

