/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.Assessment;
import software.amazon.awssdk.services.directory.model.AssessmentReport;
import software.amazon.awssdk.services.directory.model.AssessmentReportsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAdAssessmentResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeAdAssessmentResponse> {
    private static final SdkField<Assessment> ASSESSMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Assessment").getter(DescribeAdAssessmentResponse.getter(DescribeAdAssessmentResponse::assessment)).setter(DescribeAdAssessmentResponse.setter(Builder::assessment)).constructor(Assessment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Assessment").build()}).build();
    private static final SdkField<List<AssessmentReport>> ASSESSMENT_REPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AssessmentReports").getter(DescribeAdAssessmentResponse.getter(DescribeAdAssessmentResponse::assessmentReports)).setter(DescribeAdAssessmentResponse.setter(Builder::assessmentReports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentReports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssessmentReport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_FIELD, ASSESSMENT_REPORTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAdAssessmentResponse.memberNameToFieldInitializer();
    private final Assessment assessment;
    private final List<AssessmentReport> assessmentReports;

    private DescribeAdAssessmentResponse(BuilderImpl builder) {
        super(builder);
        this.assessment = builder.assessment;
        this.assessmentReports = builder.assessmentReports;
    }

    public final Assessment assessment() {
        return this.assessment;
    }

    public final boolean hasAssessmentReports() {
        return this.assessmentReports != null && !(this.assessmentReports instanceof SdkAutoConstructList);
    }

    public final List<AssessmentReport> assessmentReports() {
        return this.assessmentReports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assessment());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssessmentReports() ? this.assessmentReports() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAdAssessmentResponse)) {
            return false;
        }
        DescribeAdAssessmentResponse other = (DescribeAdAssessmentResponse)((Object)obj);
        return Objects.equals(this.assessment(), other.assessment()) && this.hasAssessmentReports() == other.hasAssessmentReports() && Objects.equals(this.assessmentReports(), other.assessmentReports());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAdAssessmentResponse").add("Assessment", (Object)this.assessment()).add("AssessmentReports", this.hasAssessmentReports() ? this.assessmentReports() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Assessment": {
                return Optional.ofNullable(clazz.cast(this.assessment()));
            }
            case "AssessmentReports": {
                return Optional.ofNullable(clazz.cast(this.assessmentReports()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Assessment", ASSESSMENT_FIELD);
        map.put("AssessmentReports", ASSESSMENT_REPORTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAdAssessmentResponse, T> g) {
        return obj -> g.apply((DescribeAdAssessmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private Assessment assessment;
        private List<AssessmentReport> assessmentReports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAdAssessmentResponse model) {
            super(model);
            this.assessment(model.assessment);
            this.assessmentReports(model.assessmentReports);
        }

        public final Assessment.Builder getAssessment() {
            return this.assessment != null ? this.assessment.toBuilder() : null;
        }

        public final void setAssessment(Assessment.BuilderImpl assessment) {
            this.assessment = assessment != null ? assessment.build() : null;
        }

        @Override
        public final Builder assessment(Assessment assessment) {
            this.assessment = assessment;
            return this;
        }

        public final List<AssessmentReport.Builder> getAssessmentReports() {
            List<AssessmentReport.Builder> result = AssessmentReportsCopier.copyToBuilder(this.assessmentReports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssessmentReports(Collection<AssessmentReport.BuilderImpl> assessmentReports) {
            this.assessmentReports = AssessmentReportsCopier.copyFromBuilder(assessmentReports);
        }

        @Override
        public final Builder assessmentReports(Collection<AssessmentReport> assessmentReports) {
            this.assessmentReports = AssessmentReportsCopier.copy(assessmentReports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReports(AssessmentReport ... assessmentReports) {
            this.assessmentReports(Arrays.asList(assessmentReports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assessmentReports(Consumer<AssessmentReport.Builder> ... assessmentReports) {
            this.assessmentReports(Stream.of(assessmentReports).map(c -> (AssessmentReport)((AssessmentReport.Builder)AssessmentReport.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAdAssessmentResponse build() {
            return new DescribeAdAssessmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAdAssessmentResponse> {
        public Builder assessment(Assessment var1);

        default public Builder assessment(Consumer<Assessment.Builder> assessment) {
            return this.assessment((Assessment)((Assessment.Builder)Assessment.builder().applyMutation(assessment)).build());
        }

        public Builder assessmentReports(Collection<AssessmentReport> var1);

        public Builder assessmentReports(AssessmentReport ... var1);

        public Builder assessmentReports(Consumer<AssessmentReport.Builder> ... var1);
    }
}

