/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.DnsIpv6AddrsCopier;
import software.amazon.awssdk.services.directory.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectoryConnectSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectoryConnectSettings> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DirectoryConnectSettings.getter(DirectoryConnectSettings::vpcId)).setter(DirectoryConnectSettings.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(DirectoryConnectSettings.getter(DirectoryConnectSettings::subnetIds)).setter(DirectoryConnectSettings.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIps").getter(DirectoryConnectSettings.getter(DirectoryConnectSettings::customerDnsIps)).setter(DirectoryConnectSettings.setter(Builder::customerDnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_V6_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIpsV6").getter(DirectoryConnectSettings.getter(DirectoryConnectSettings::customerDnsIpsV6)).setter(DirectoryConnectSettings.setter(Builder::customerDnsIpsV6)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIpsV6").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerUserName").getter(DirectoryConnectSettings.getter(DirectoryConnectSettings::customerUserName)).setter(DirectoryConnectSettings.setter(Builder::customerUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD, SUBNET_IDS_FIELD, CUSTOMER_DNS_IPS_FIELD, CUSTOMER_DNS_IPS_V6_FIELD, CUSTOMER_USER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectoryConnectSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> customerDnsIps;
    private final List<String> customerDnsIpsV6;
    private final String customerUserName;

    private DirectoryConnectSettings(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.customerDnsIps = builder.customerDnsIps;
        this.customerDnsIpsV6 = builder.customerDnsIpsV6;
        this.customerUserName = builder.customerUserName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasCustomerDnsIps() {
        return this.customerDnsIps != null && !(this.customerDnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIps() {
        return this.customerDnsIps;
    }

    public final boolean hasCustomerDnsIpsV6() {
        return this.customerDnsIpsV6 != null && !(this.customerDnsIpsV6 instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIpsV6() {
        return this.customerDnsIpsV6;
    }

    public final String customerUserName() {
        return this.customerUserName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIps() ? this.customerDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIpsV6() ? this.customerDnsIpsV6() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerUserName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettings)) {
            return false;
        }
        DirectoryConnectSettings other = (DirectoryConnectSettings)obj;
        return Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasCustomerDnsIps() == other.hasCustomerDnsIps() && Objects.equals(this.customerDnsIps(), other.customerDnsIps()) && this.hasCustomerDnsIpsV6() == other.hasCustomerDnsIpsV6() && Objects.equals(this.customerDnsIpsV6(), other.customerDnsIpsV6()) && Objects.equals(this.customerUserName(), other.customerUserName());
    }

    public final String toString() {
        return ToString.builder((String)"DirectoryConnectSettings").add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("CustomerDnsIps", this.hasCustomerDnsIps() ? this.customerDnsIps() : null).add("CustomerDnsIpsV6", this.hasCustomerDnsIpsV6() ? this.customerDnsIpsV6() : null).add("CustomerUserName", (Object)this.customerUserName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "CustomerDnsIps": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIps()));
            }
            case "CustomerDnsIpsV6": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIpsV6()));
            }
            case "CustomerUserName": {
                return Optional.ofNullable(clazz.cast(this.customerUserName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("CustomerDnsIps", CUSTOMER_DNS_IPS_FIELD);
        map.put("CustomerDnsIpsV6", CUSTOMER_DNS_IPS_V6_FIELD);
        map.put("CustomerUserName", CUSTOMER_USER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConnectSettings, T> g) {
        return obj -> g.apply((DirectoryConnectSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();
        private List<String> customerDnsIpsV6 = DefaultSdkAutoConstructList.getInstance();
        private String customerUserName;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConnectSettings model) {
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.customerDnsIps(model.customerDnsIps);
            this.customerDnsIpsV6(model.customerDnsIpsV6);
            this.customerUserName(model.customerUserName);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getCustomerDnsIps() {
            if (this.customerDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIps;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = DnsIpAddrsCopier.copy(customerDnsIps);
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = DnsIpAddrsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String ... customerDnsIps) {
            this.customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final Collection<String> getCustomerDnsIpsV6() {
            if (this.customerDnsIpsV6 instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIpsV6;
        }

        public final void setCustomerDnsIpsV6(Collection<String> customerDnsIpsV6) {
            this.customerDnsIpsV6 = DnsIpv6AddrsCopier.copy(customerDnsIpsV6);
        }

        @Override
        public final Builder customerDnsIpsV6(Collection<String> customerDnsIpsV6) {
            this.customerDnsIpsV6 = DnsIpv6AddrsCopier.copy(customerDnsIpsV6);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIpsV6(String ... customerDnsIpsV6) {
            this.customerDnsIpsV6(Arrays.asList(customerDnsIpsV6));
            return this;
        }

        public final String getCustomerUserName() {
            return this.customerUserName;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public DirectoryConnectSettings build() {
            return new DirectoryConnectSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectoryConnectSettings> {
        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder customerDnsIps(Collection<String> var1);

        public Builder customerDnsIps(String ... var1);

        public Builder customerDnsIpsV6(Collection<String> var1);

        public Builder customerDnsIpsV6(String ... var1);

        public Builder customerUserName(String var1);
    }
}

