/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AssessmentInstanceIdsCopier;
import software.amazon.awssdk.services.directory.model.IpAddrsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HybridSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HybridSettingsDescription> {
    private static final SdkField<List<String>> SELF_MANAGED_DNS_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelfManagedDnsIpAddrs").getter(HybridSettingsDescription.getter(HybridSettingsDescription::selfManagedDnsIpAddrs)).setter(HybridSettingsDescription.setter(Builder::selfManagedDnsIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedDnsIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELF_MANAGED_INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelfManagedInstanceIds").getter(HybridSettingsDescription.getter(HybridSettingsDescription::selfManagedInstanceIds)).setter(HybridSettingsDescription.setter(Builder::selfManagedInstanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELF_MANAGED_DNS_IP_ADDRS_FIELD, SELF_MANAGED_INSTANCE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HybridSettingsDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> selfManagedDnsIpAddrs;
    private final List<String> selfManagedInstanceIds;

    private HybridSettingsDescription(BuilderImpl builder) {
        this.selfManagedDnsIpAddrs = builder.selfManagedDnsIpAddrs;
        this.selfManagedInstanceIds = builder.selfManagedInstanceIds;
    }

    public final boolean hasSelfManagedDnsIpAddrs() {
        return this.selfManagedDnsIpAddrs != null && !(this.selfManagedDnsIpAddrs instanceof SdkAutoConstructList);
    }

    public final List<String> selfManagedDnsIpAddrs() {
        return this.selfManagedDnsIpAddrs;
    }

    public final boolean hasSelfManagedInstanceIds() {
        return this.selfManagedInstanceIds != null && !(this.selfManagedInstanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> selfManagedInstanceIds() {
        return this.selfManagedInstanceIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelfManagedDnsIpAddrs() ? this.selfManagedDnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelfManagedInstanceIds() ? this.selfManagedInstanceIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridSettingsDescription)) {
            return false;
        }
        HybridSettingsDescription other = (HybridSettingsDescription)obj;
        return this.hasSelfManagedDnsIpAddrs() == other.hasSelfManagedDnsIpAddrs() && Objects.equals(this.selfManagedDnsIpAddrs(), other.selfManagedDnsIpAddrs()) && this.hasSelfManagedInstanceIds() == other.hasSelfManagedInstanceIds() && Objects.equals(this.selfManagedInstanceIds(), other.selfManagedInstanceIds());
    }

    public final String toString() {
        return ToString.builder((String)"HybridSettingsDescription").add("SelfManagedDnsIpAddrs", this.hasSelfManagedDnsIpAddrs() ? this.selfManagedDnsIpAddrs() : null).add("SelfManagedInstanceIds", this.hasSelfManagedInstanceIds() ? this.selfManagedInstanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelfManagedDnsIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.selfManagedDnsIpAddrs()));
            }
            case "SelfManagedInstanceIds": {
                return Optional.ofNullable(clazz.cast(this.selfManagedInstanceIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("SelfManagedDnsIpAddrs", SELF_MANAGED_DNS_IP_ADDRS_FIELD);
        map.put("SelfManagedInstanceIds", SELF_MANAGED_INSTANCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridSettingsDescription, T> g) {
        return obj -> g.apply((HybridSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> selfManagedDnsIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private List<String> selfManagedInstanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HybridSettingsDescription model) {
            this.selfManagedDnsIpAddrs(model.selfManagedDnsIpAddrs);
            this.selfManagedInstanceIds(model.selfManagedInstanceIds);
        }

        public final Collection<String> getSelfManagedDnsIpAddrs() {
            if (this.selfManagedDnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selfManagedDnsIpAddrs;
        }

        public final void setSelfManagedDnsIpAddrs(Collection<String> selfManagedDnsIpAddrs) {
            this.selfManagedDnsIpAddrs = IpAddrsCopier.copy(selfManagedDnsIpAddrs);
        }

        @Override
        public final Builder selfManagedDnsIpAddrs(Collection<String> selfManagedDnsIpAddrs) {
            this.selfManagedDnsIpAddrs = IpAddrsCopier.copy(selfManagedDnsIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedDnsIpAddrs(String ... selfManagedDnsIpAddrs) {
            this.selfManagedDnsIpAddrs(Arrays.asList(selfManagedDnsIpAddrs));
            return this;
        }

        public final Collection<String> getSelfManagedInstanceIds() {
            if (this.selfManagedInstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selfManagedInstanceIds;
        }

        public final void setSelfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
        }

        @Override
        public final Builder selfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedInstanceIds(String ... selfManagedInstanceIds) {
            this.selfManagedInstanceIds(Arrays.asList(selfManagedInstanceIds));
            return this;
        }

        public HybridSettingsDescription build() {
            return new HybridSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HybridSettingsDescription> {
        public Builder selfManagedDnsIpAddrs(Collection<String> var1);

        public Builder selfManagedDnsIpAddrs(String ... var1);

        public Builder selfManagedInstanceIds(Collection<String> var1);

        public Builder selfManagedInstanceIds(String ... var1);
    }
}

