/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HybridUpdateType {
    SELF_MANAGED_INSTANCES("SelfManagedInstances"),
    HYBRID_ADMINISTRATOR_ACCOUNT("HybridAdministratorAccount"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HybridUpdateType> VALUE_MAP;
    private final String value;

    private HybridUpdateType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HybridUpdateType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HybridUpdateType> knownValues() {
        EnumSet<HybridUpdateType> knownValues = EnumSet.allOf(HybridUpdateType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HybridUpdateType.class, HybridUpdateType::toString);
    }
}

