/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.LDAPSSettingInfo;

public class DescribeLDAPSSettingsIterable
implements SdkIterable<DescribeLdapsSettingsResponse> {
    private final DirectoryClient client;
    private final DescribeLdapsSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLDAPSSettingsIterable(DirectoryClient client, DescribeLdapsSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLdapsSettingsResponseFetcher();
    }

    public Iterator<DescribeLdapsSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LDAPSSettingInfo> ldapsSettingsInfo() {
        Function<DescribeLdapsSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ldapsSettingsInfo() != null) {
                return response.ldapsSettingsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLdapsSettingsResponseFetcher
    implements SyncPageFetcher<DescribeLdapsSettingsResponse> {
        private DescribeLdapsSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLdapsSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLdapsSettingsResponse nextPage(DescribeLdapsSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLDAPSSettingsIterable.this.client.describeLDAPSSettings(DescribeLDAPSSettingsIterable.this.firstRequest);
            }
            return DescribeLDAPSSettingsIterable.this.client.describeLDAPSSettings((DescribeLdapsSettingsRequest)((Object)DescribeLDAPSSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

