/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.ExecutionHandlerServiceValues;
import software.amazon.awssdk.services.dlm.model.StageValues;
import software.amazon.awssdk.services.dlm.model.StagesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Script
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Script> {
    private static final SdkField<List<String>> STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stages").getter(Script.getter(Script::stagesAsStrings)).setter(Script.setter(Builder::stagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_HANDLER_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionHandlerService").getter(Script.getter(Script::executionHandlerServiceAsString)).setter(Script.setter(Builder::executionHandlerService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionHandlerService").build()}).build();
    private static final SdkField<String> EXECUTION_HANDLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionHandler").getter(Script.getter(Script::executionHandler)).setter(Script.setter(Builder::executionHandler)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionHandler").build()}).build();
    private static final SdkField<Boolean> EXECUTE_OPERATION_ON_SCRIPT_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ExecuteOperationOnScriptFailure").getter(Script.getter(Script::executeOperationOnScriptFailure)).setter(Script.setter(Builder::executeOperationOnScriptFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecuteOperationOnScriptFailure").build()}).build();
    private static final SdkField<Integer> EXECUTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExecutionTimeout").getter(Script.getter(Script::executionTimeout)).setter(Script.setter(Builder::executionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeout").build()}).build();
    private static final SdkField<Integer> MAXIMUM_RETRY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaximumRetryCount").getter(Script.getter(Script::maximumRetryCount)).setter(Script.setter(Builder::maximumRetryCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumRetryCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGES_FIELD, EXECUTION_HANDLER_SERVICE_FIELD, EXECUTION_HANDLER_FIELD, EXECUTE_OPERATION_ON_SCRIPT_FAILURE_FIELD, EXECUTION_TIMEOUT_FIELD, MAXIMUM_RETRY_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> stages;
    private final String executionHandlerService;
    private final String executionHandler;
    private final Boolean executeOperationOnScriptFailure;
    private final Integer executionTimeout;
    private final Integer maximumRetryCount;

    private Script(BuilderImpl builder) {
        this.stages = builder.stages;
        this.executionHandlerService = builder.executionHandlerService;
        this.executionHandler = builder.executionHandler;
        this.executeOperationOnScriptFailure = builder.executeOperationOnScriptFailure;
        this.executionTimeout = builder.executionTimeout;
        this.maximumRetryCount = builder.maximumRetryCount;
    }

    public final List<StageValues> stages() {
        return StagesListCopier.copyStringToEnum(this.stages);
    }

    public final boolean hasStages() {
        return this.stages != null && !(this.stages instanceof SdkAutoConstructList);
    }

    public final List<String> stagesAsStrings() {
        return this.stages;
    }

    public final ExecutionHandlerServiceValues executionHandlerService() {
        return ExecutionHandlerServiceValues.fromValue(this.executionHandlerService);
    }

    public final String executionHandlerServiceAsString() {
        return this.executionHandlerService;
    }

    public final String executionHandler() {
        return this.executionHandler;
    }

    public final Boolean executeOperationOnScriptFailure() {
        return this.executeOperationOnScriptFailure;
    }

    public final Integer executionTimeout() {
        return this.executionTimeout;
    }

    public final Integer maximumRetryCount() {
        return this.maximumRetryCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStages() ? this.stagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionHandlerServiceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionHandler());
        hashCode = 31 * hashCode + Objects.hashCode(this.executeOperationOnScriptFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumRetryCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Script)) {
            return false;
        }
        Script other = (Script)obj;
        return this.hasStages() == other.hasStages() && Objects.equals(this.stagesAsStrings(), other.stagesAsStrings()) && Objects.equals(this.executionHandlerServiceAsString(), other.executionHandlerServiceAsString()) && Objects.equals(this.executionHandler(), other.executionHandler()) && Objects.equals(this.executeOperationOnScriptFailure(), other.executeOperationOnScriptFailure()) && Objects.equals(this.executionTimeout(), other.executionTimeout()) && Objects.equals(this.maximumRetryCount(), other.maximumRetryCount());
    }

    public final String toString() {
        return ToString.builder((String)"Script").add("Stages", this.hasStages() ? this.stagesAsStrings() : null).add("ExecutionHandlerService", (Object)this.executionHandlerServiceAsString()).add("ExecutionHandler", (Object)this.executionHandler()).add("ExecuteOperationOnScriptFailure", (Object)this.executeOperationOnScriptFailure()).add("ExecutionTimeout", (Object)this.executionTimeout()).add("MaximumRetryCount", (Object)this.maximumRetryCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stages": {
                return Optional.ofNullable(clazz.cast(this.stagesAsStrings()));
            }
            case "ExecutionHandlerService": {
                return Optional.ofNullable(clazz.cast(this.executionHandlerServiceAsString()));
            }
            case "ExecutionHandler": {
                return Optional.ofNullable(clazz.cast(this.executionHandler()));
            }
            case "ExecuteOperationOnScriptFailure": {
                return Optional.ofNullable(clazz.cast(this.executeOperationOnScriptFailure()));
            }
            case "ExecutionTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionTimeout()));
            }
            case "MaximumRetryCount": {
                return Optional.ofNullable(clazz.cast(this.maximumRetryCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Script, T> g) {
        return obj -> g.apply((Script)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> stages = DefaultSdkAutoConstructList.getInstance();
        private String executionHandlerService;
        private String executionHandler;
        private Boolean executeOperationOnScriptFailure;
        private Integer executionTimeout;
        private Integer maximumRetryCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Script model) {
            this.stagesWithStrings(model.stages);
            this.executionHandlerService(model.executionHandlerService);
            this.executionHandler(model.executionHandler);
            this.executeOperationOnScriptFailure(model.executeOperationOnScriptFailure);
            this.executionTimeout(model.executionTimeout);
            this.maximumRetryCount(model.maximumRetryCount);
        }

        public final Collection<String> getStages() {
            if (this.stages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stages;
        }

        public final void setStages(Collection<String> stages) {
            this.stages = StagesListCopier.copy(stages);
        }

        @Override
        public final Builder stagesWithStrings(Collection<String> stages) {
            this.stages = StagesListCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stagesWithStrings(String ... stages) {
            this.stagesWithStrings(Arrays.asList(stages));
            return this;
        }

        @Override
        public final Builder stages(Collection<StageValues> stages) {
            this.stages = StagesListCopier.copyEnumToString(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(StageValues ... stages) {
            this.stages(Arrays.asList(stages));
            return this;
        }

        public final String getExecutionHandlerService() {
            return this.executionHandlerService;
        }

        public final void setExecutionHandlerService(String executionHandlerService) {
            this.executionHandlerService = executionHandlerService;
        }

        @Override
        public final Builder executionHandlerService(String executionHandlerService) {
            this.executionHandlerService = executionHandlerService;
            return this;
        }

        @Override
        public final Builder executionHandlerService(ExecutionHandlerServiceValues executionHandlerService) {
            this.executionHandlerService(executionHandlerService == null ? null : executionHandlerService.toString());
            return this;
        }

        public final String getExecutionHandler() {
            return this.executionHandler;
        }

        public final void setExecutionHandler(String executionHandler) {
            this.executionHandler = executionHandler;
        }

        @Override
        public final Builder executionHandler(String executionHandler) {
            this.executionHandler = executionHandler;
            return this;
        }

        public final Boolean getExecuteOperationOnScriptFailure() {
            return this.executeOperationOnScriptFailure;
        }

        public final void setExecuteOperationOnScriptFailure(Boolean executeOperationOnScriptFailure) {
            this.executeOperationOnScriptFailure = executeOperationOnScriptFailure;
        }

        @Override
        public final Builder executeOperationOnScriptFailure(Boolean executeOperationOnScriptFailure) {
            this.executeOperationOnScriptFailure = executeOperationOnScriptFailure;
            return this;
        }

        public final Integer getExecutionTimeout() {
            return this.executionTimeout;
        }

        public final void setExecutionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Integer executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final Integer getMaximumRetryCount() {
            return this.maximumRetryCount;
        }

        public final void setMaximumRetryCount(Integer maximumRetryCount) {
            this.maximumRetryCount = maximumRetryCount;
        }

        @Override
        public final Builder maximumRetryCount(Integer maximumRetryCount) {
            this.maximumRetryCount = maximumRetryCount;
            return this;
        }

        public Script build() {
            return new Script(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Script> {
        public Builder stagesWithStrings(Collection<String> var1);

        public Builder stagesWithStrings(String ... var1);

        public Builder stages(Collection<StageValues> var1);

        public Builder stages(StageValues ... var1);

        public Builder executionHandlerService(String var1);

        public Builder executionHandlerService(ExecutionHandlerServiceValues var1);

        public Builder executionHandler(String var1);

        public Builder executeOperationOnScriptFailure(Boolean var1);

        public Builder executionTimeout(Integer var1);

        public Builder maximumRetryCount(Integer var1);
    }
}

