/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StageValues {
    PRE("PRE"),
    POST("POST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StageValues> VALUE_MAP;
    private final String value;

    private StageValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StageValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StageValues> knownValues() {
        EnumSet<StageValues> knownValues = EnumSet.allOf(StageValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StageValues.class, StageValues::toString);
    }
}

