/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.docdb.model.FailoverStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailoverState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailoverState> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(FailoverState.getter(FailoverState::statusAsString)).setter(FailoverState.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FROM_DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FromDbClusterArn").getter(FailoverState.getter(FailoverState::fromDbClusterArn)).setter(FailoverState.setter(Builder::fromDbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FromDbClusterArn").build()}).build();
    private static final SdkField<String> TO_DB_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ToDbClusterArn").getter(FailoverState.getter(FailoverState::toDbClusterArn)).setter(FailoverState.setter(Builder::toDbClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToDbClusterArn").build()}).build();
    private static final SdkField<Boolean> IS_DATA_LOSS_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsDataLossAllowed").getter(FailoverState.getter(FailoverState::isDataLossAllowed)).setter(FailoverState.setter(Builder::isDataLossAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDataLossAllowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, FROM_DB_CLUSTER_ARN_FIELD, TO_DB_CLUSTER_ARN_FIELD, IS_DATA_LOSS_ALLOWED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FailoverState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String fromDbClusterArn;
    private final String toDbClusterArn;
    private final Boolean isDataLossAllowed;

    private FailoverState(BuilderImpl builder) {
        this.status = builder.status;
        this.fromDbClusterArn = builder.fromDbClusterArn;
        this.toDbClusterArn = builder.toDbClusterArn;
        this.isDataLossAllowed = builder.isDataLossAllowed;
    }

    public final FailoverStatus status() {
        return FailoverStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String fromDbClusterArn() {
        return this.fromDbClusterArn;
    }

    public final String toDbClusterArn() {
        return this.toDbClusterArn;
    }

    public final Boolean isDataLossAllowed() {
        return this.isDataLossAllowed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.toDbClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDataLossAllowed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverState)) {
            return false;
        }
        FailoverState other = (FailoverState)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.fromDbClusterArn(), other.fromDbClusterArn()) && Objects.equals(this.toDbClusterArn(), other.toDbClusterArn()) && Objects.equals(this.isDataLossAllowed(), other.isDataLossAllowed());
    }

    public final String toString() {
        return ToString.builder((String)"FailoverState").add("Status", (Object)this.statusAsString()).add("FromDbClusterArn", (Object)this.fromDbClusterArn()).add("ToDbClusterArn", (Object)this.toDbClusterArn()).add("IsDataLossAllowed", (Object)this.isDataLossAllowed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FromDbClusterArn": {
                return Optional.ofNullable(clazz.cast(this.fromDbClusterArn()));
            }
            case "ToDbClusterArn": {
                return Optional.ofNullable(clazz.cast(this.toDbClusterArn()));
            }
            case "IsDataLossAllowed": {
                return Optional.ofNullable(clazz.cast(this.isDataLossAllowed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("FromDbClusterArn", FROM_DB_CLUSTER_ARN_FIELD);
        map.put("ToDbClusterArn", TO_DB_CLUSTER_ARN_FIELD);
        map.put("IsDataLossAllowed", IS_DATA_LOSS_ALLOWED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FailoverState, T> g) {
        return obj -> g.apply((FailoverState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String fromDbClusterArn;
        private String toDbClusterArn;
        private Boolean isDataLossAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverState model) {
            this.status(model.status);
            this.fromDbClusterArn(model.fromDbClusterArn);
            this.toDbClusterArn(model.toDbClusterArn);
            this.isDataLossAllowed(model.isDataLossAllowed);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FailoverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFromDbClusterArn() {
            return this.fromDbClusterArn;
        }

        public final void setFromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
        }

        @Override
        public final Builder fromDbClusterArn(String fromDbClusterArn) {
            this.fromDbClusterArn = fromDbClusterArn;
            return this;
        }

        public final String getToDbClusterArn() {
            return this.toDbClusterArn;
        }

        public final void setToDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
        }

        @Override
        public final Builder toDbClusterArn(String toDbClusterArn) {
            this.toDbClusterArn = toDbClusterArn;
            return this;
        }

        public final Boolean getIsDataLossAllowed() {
            return this.isDataLossAllowed;
        }

        public final void setIsDataLossAllowed(Boolean isDataLossAllowed) {
            this.isDataLossAllowed = isDataLossAllowed;
        }

        @Override
        public final Builder isDataLossAllowed(Boolean isDataLossAllowed) {
            this.isDataLossAllowed = isDataLossAllowed;
            return this;
        }

        public FailoverState build() {
            return new FailoverState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailoverState> {
        public Builder status(String var1);

        public Builder status(FailoverStatus var1);

        public Builder fromDbClusterArn(String var1);

        public Builder toDbClusterArn(String var1);

        public Builder isDataLossAllowed(Boolean var1);
    }
}

