/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.drs.model.DrsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateSourceNetworkStackRequest
extends DrsRequest
implements ToCopyableBuilder<Builder, AssociateSourceNetworkStackRequest> {
    private static final SdkField<String> CFN_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cfnStackName").getter(AssociateSourceNetworkStackRequest.getter(AssociateSourceNetworkStackRequest::cfnStackName)).setter(AssociateSourceNetworkStackRequest.setter(Builder::cfnStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cfnStackName").build()}).build();
    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceNetworkID").getter(AssociateSourceNetworkStackRequest.getter(AssociateSourceNetworkStackRequest::sourceNetworkID)).setter(AssociateSourceNetworkStackRequest.setter(Builder::sourceNetworkID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CFN_STACK_NAME_FIELD, SOURCE_NETWORK_ID_FIELD));
    private final String cfnStackName;
    private final String sourceNetworkID;

    private AssociateSourceNetworkStackRequest(BuilderImpl builder) {
        super(builder);
        this.cfnStackName = builder.cfnStackName;
        this.sourceNetworkID = builder.sourceNetworkID;
    }

    public final String cfnStackName() {
        return this.cfnStackName;
    }

    public final String sourceNetworkID() {
        return this.sourceNetworkID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cfnStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceNetworkID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSourceNetworkStackRequest)) {
            return false;
        }
        AssociateSourceNetworkStackRequest other = (AssociateSourceNetworkStackRequest)((Object)obj);
        return Objects.equals(this.cfnStackName(), other.cfnStackName()) && Objects.equals(this.sourceNetworkID(), other.sourceNetworkID());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateSourceNetworkStackRequest").add("CfnStackName", (Object)(this.cfnStackName() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceNetworkID", (Object)this.sourceNetworkID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cfnStackName": {
                return Optional.ofNullable(clazz.cast(this.cfnStackName()));
            }
            case "sourceNetworkID": {
                return Optional.ofNullable(clazz.cast(this.sourceNetworkID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSourceNetworkStackRequest, T> g) {
        return obj -> g.apply((AssociateSourceNetworkStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DrsRequest.BuilderImpl
    implements Builder {
        private String cfnStackName;
        private String sourceNetworkID;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSourceNetworkStackRequest model) {
            super(model);
            this.cfnStackName(model.cfnStackName);
            this.sourceNetworkID(model.sourceNetworkID);
        }

        public final String getCfnStackName() {
            return this.cfnStackName;
        }

        public final void setCfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
        }

        @Override
        public final Builder cfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
            return this;
        }

        public final String getSourceNetworkID() {
            return this.sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateSourceNetworkStackRequest build() {
            return new AssociateSourceNetworkStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DrsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateSourceNetworkStackRequest> {
        public Builder cfnStackName(String var1);

        public Builder sourceNetworkID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

