/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CPU
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CPU> {
    private static final SdkField<Long> CORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("cores").getter(CPU.getter(CPU::cores)).setter(CPU.setter(Builder::cores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cores").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(CPU.getter(CPU::modelName)).setter(CPU.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORES_FIELD, MODEL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long cores;
    private final String modelName;

    private CPU(BuilderImpl builder) {
        this.cores = builder.cores;
        this.modelName = builder.modelName;
    }

    public final Long cores() {
        return this.cores;
    }

    public final String modelName() {
        return this.modelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cores());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CPU)) {
            return false;
        }
        CPU other = (CPU)obj;
        return Objects.equals(this.cores(), other.cores()) && Objects.equals(this.modelName(), other.modelName());
    }

    public final String toString() {
        return ToString.builder((String)"CPU").add("Cores", (Object)this.cores()).add("ModelName", (Object)this.modelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cores": {
                return Optional.ofNullable(clazz.cast(this.cores()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CPU, T> g) {
        return obj -> g.apply((CPU)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long cores;
        private String modelName;

        private BuilderImpl() {
        }

        private BuilderImpl(CPU model) {
            this.cores(model.cores);
            this.modelName(model.modelName);
        }

        public final Long getCores() {
            return this.cores;
        }

        public final void setCores(Long cores) {
            this.cores = cores;
        }

        @Override
        public final Builder cores(Long cores) {
            this.cores = cores;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public CPU build() {
            return new CPU(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CPU> {
        public Builder cores(Long var1);

        public Builder modelName(String var1);
    }
}

