/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.DescribeJobsRequestFiltersJobIDsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeJobsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeJobsRequestFilters> {
    private static final SdkField<String> FROM_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fromDate").getter(DescribeJobsRequestFilters.getter(DescribeJobsRequestFilters::fromDate)).setter(DescribeJobsRequestFilters.setter(Builder::fromDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDate").build()}).build();
    private static final SdkField<List<String>> JOB_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("jobIDs").getter(DescribeJobsRequestFilters.getter(DescribeJobsRequestFilters::jobIDs)).setter(DescribeJobsRequestFilters.setter(Builder::jobIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TO_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("toDate").getter(DescribeJobsRequestFilters.getter(DescribeJobsRequestFilters::toDate)).setter(DescribeJobsRequestFilters.setter(Builder::toDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_DATE_FIELD, JOB_I_DS_FIELD, TO_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeJobsRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fromDate;
    private final List<String> jobIDs;
    private final String toDate;

    private DescribeJobsRequestFilters(BuilderImpl builder) {
        this.fromDate = builder.fromDate;
        this.jobIDs = builder.jobIDs;
        this.toDate = builder.toDate;
    }

    public final String fromDate() {
        return this.fromDate;
    }

    public final boolean hasJobIDs() {
        return this.jobIDs != null && !(this.jobIDs instanceof SdkAutoConstructList);
    }

    public final List<String> jobIDs() {
        return this.jobIDs;
    }

    public final String toDate() {
        return this.toDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobIDs() ? this.jobIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.toDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequestFilters)) {
            return false;
        }
        DescribeJobsRequestFilters other = (DescribeJobsRequestFilters)obj;
        return Objects.equals(this.fromDate(), other.fromDate()) && this.hasJobIDs() == other.hasJobIDs() && Objects.equals(this.jobIDs(), other.jobIDs()) && Objects.equals(this.toDate(), other.toDate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeJobsRequestFilters").add("FromDate", (Object)this.fromDate()).add("JobIDs", this.hasJobIDs() ? this.jobIDs() : null).add("ToDate", (Object)this.toDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fromDate": {
                return Optional.ofNullable(clazz.cast(this.fromDate()));
            }
            case "jobIDs": {
                return Optional.ofNullable(clazz.cast(this.jobIDs()));
            }
            case "toDate": {
                return Optional.ofNullable(clazz.cast(this.toDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fromDate", FROM_DATE_FIELD);
        map.put("jobIDs", JOB_I_DS_FIELD);
        map.put("toDate", TO_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobsRequestFilters, T> g) {
        return obj -> g.apply((DescribeJobsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fromDate;
        private List<String> jobIDs = DefaultSdkAutoConstructList.getInstance();
        private String toDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequestFilters model) {
            this.fromDate(model.fromDate);
            this.jobIDs(model.jobIDs);
            this.toDate(model.toDate);
        }

        public final String getFromDate() {
            return this.fromDate;
        }

        public final void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        @Override
        public final Builder fromDate(String fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final Collection<String> getJobIDs() {
            if (this.jobIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.jobIDs;
        }

        public final void setJobIDs(Collection<String> jobIDs) {
            this.jobIDs = DescribeJobsRequestFiltersJobIDsCopier.copy(jobIDs);
        }

        @Override
        public final Builder jobIDs(Collection<String> jobIDs) {
            this.jobIDs = DescribeJobsRequestFiltersJobIDsCopier.copy(jobIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIDs(String ... jobIDs) {
            this.jobIDs(Arrays.asList(jobIDs));
            return this;
        }

        public final String getToDate() {
            return this.toDate;
        }

        public final void setToDate(String toDate) {
            this.toDate = toDate;
        }

        @Override
        public final Builder toDate(String toDate) {
            this.toDate = toDate;
            return this;
        }

        public DescribeJobsRequestFilters build() {
            return new DescribeJobsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeJobsRequestFilters> {
        public Builder fromDate(String var1);

        public Builder jobIDs(Collection<String> var1);

        public Builder jobIDs(String ... var1);

        public Builder toDate(String var1);
    }
}

