/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.drs.model.LaunchActionIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchActionsRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchActionsRequestFilters> {
    private static final SdkField<List<String>> ACTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionIds").getter(LaunchActionsRequestFilters.getter(LaunchActionsRequestFilters::actionIds)).setter(LaunchActionsRequestFilters.setter(Builder::actionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LaunchActionsRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> actionIds;

    private LaunchActionsRequestFilters(BuilderImpl builder) {
        this.actionIds = builder.actionIds;
    }

    public final boolean hasActionIds() {
        return this.actionIds != null && !(this.actionIds instanceof SdkAutoConstructList);
    }

    public final List<String> actionIds() {
        return this.actionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionIds() ? this.actionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchActionsRequestFilters)) {
            return false;
        }
        LaunchActionsRequestFilters other = (LaunchActionsRequestFilters)obj;
        return this.hasActionIds() == other.hasActionIds() && Objects.equals(this.actionIds(), other.actionIds());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchActionsRequestFilters").add("ActionIds", this.hasActionIds() ? this.actionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionIds": {
                return Optional.ofNullable(clazz.cast(this.actionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("actionIds", ACTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LaunchActionsRequestFilters, T> g) {
        return obj -> g.apply((LaunchActionsRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchActionsRequestFilters model) {
            this.actionIds(model.actionIds);
        }

        public final Collection<String> getActionIds() {
            if (this.actionIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionIds;
        }

        public final void setActionIds(Collection<String> actionIds) {
            this.actionIds = LaunchActionIdsCopier.copy(actionIds);
        }

        @Override
        public final Builder actionIds(Collection<String> actionIds) {
            this.actionIds = LaunchActionIdsCopier.copy(actionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionIds(String ... actionIds) {
            this.actionIds(Arrays.asList(actionIds));
            return this;
        }

        public LaunchActionsRequestFilters build() {
            return new LaunchActionsRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchActionsRequestFilters> {
        public Builder actionIds(Collection<String> var1);

        public Builder actionIds(String ... var1);
    }
}

